/*
 * Decompiled with CFR 0.152.
 */
package com.mcwwindows.kikoz.objects;

import com.mcwwindows.kikoz.init.ItemInit;
import com.mcwwindows.kikoz.init.SoundsInit;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class WindowBarred
extends Block {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final EnumProperty<WindowState> WINDOWSTATE = EnumProperty.m_61587_((String)"windowstate", WindowState.class);
    protected static final VoxelShape EE = WindowBarred.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);
    protected static final VoxelShape NN = WindowBarred.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0);
    protected static final VoxelShape FIX = WindowBarred.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.1, (double)0.0);

    public WindowBarred(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)Direction.NORTH)).m_61124_(WINDOWSTATE, (Comparable)((Object)WindowState.CLOSED)));
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        WindowState windowState = (WindowState)((Object)state.m_61143_(WINDOWSTATE));
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        if (windowState == WindowState.OPEN_LEFT || windowState == WindowState.OPEN_RIGHT) {
            return FIX;
        }
        if (direction == Direction.NORTH || direction == Direction.SOUTH) {
            return EE;
        }
        return NN;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        WindowState newState;
        ItemStack itemstack = player.m_21120_(handIn);
        Item item = itemstack.m_41720_();
        WindowState windowState = (WindowState)((Object)state.m_61143_(WINDOWSTATE));
        if (item == ItemInit.KEY.get()) {
            this.lockWindow(level, pos, windowState != WindowState.LOCKED, (Direction)state.m_61143_((Property)FACING), 1000);
            level.m_5594_(null, pos, SoundEvents.f_12011_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
            state = (BlockState)state.m_61124_(WINDOWSTATE, (Comparable)((Object)(windowState == WindowState.LOCKED ? WindowState.CLOSED : WindowState.LOCKED)));
            level.m_7731_(pos, state, 10);
            return InteractionResult.SUCCESS;
        }
        if (windowState == WindowState.LOCKED || item == this.m_5456_()) {
            return InteractionResult.PASS;
        }
        if (windowState == WindowState.CLOSED) {
            newState = WindowState.OPEN_LEFT;
            this.toggleWindowState(level, pos, windowState);
            level.m_5594_(null, pos, (SoundEvent)SoundsInit.WINDOW_OPEN.get(), SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
        } else if (windowState == WindowState.OPEN_LEFT) {
            newState = WindowState.OPEN_RIGHT;
            this.toggleWindowState(level, pos, windowState);
            level.m_5594_(null, pos, (SoundEvent)SoundsInit.WINDOW_OPEN.get(), SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
        } else {
            newState = WindowState.CLOSED;
            this.toggleWindowState(level, pos, windowState);
            level.m_5594_(null, pos, (SoundEvent)SoundsInit.WINDOW_CLOSE.get(), SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
        }
        state = (BlockState)state.m_61124_(WINDOWSTATE, (Comparable)((Object)newState));
        level.m_7731_(pos, state, 10);
        return InteractionResult.SUCCESS;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return mirror == Mirror.NONE ? state : state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_() == Direction.Axis.X ? NN : EE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, WINDOWSTATE});
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState updatePostPlacement(BlockState stateIn, Direction facing, BlockState facingState, Level worldIn, BlockPos currentPos, BlockPos facingPos) {
        return super.m_7417_(stateIn, facing, facingState, (LevelAccessor)worldIn, currentPos, facingPos);
    }

    private void toggleWindowState(Level world, BlockPos pos, WindowState currentState) {
        BlockState state = world.m_8055_(pos);
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        WindowState newState = currentState == WindowState.CLOSED ? WindowState.OPEN_LEFT : (currentState == WindowState.OPEN_LEFT ? WindowState.OPEN_RIGHT : WindowState.CLOSED);
        world.m_46597_(pos, (BlockState)state.m_61124_(WINDOWSTATE, (Comparable)((Object)newState)));
        this.toggleAdjacentWindows(world, pos.m_7494_(), facing, newState, 0, 100);
        this.toggleAdjacentWindows(world, pos.m_7495_(), facing, newState, 0, 100);
    }

    private void toggleAdjacentWindows(Level world, BlockPos pos, Direction facing, WindowState newState, int depth, int maxDepth) {
        BlockState state = world.m_8055_(pos);
        if (depth > maxDepth || state.m_60734_() != this || state.m_61143_((Property)FACING) != facing) {
            return;
        }
        if (state.m_61143_(WINDOWSTATE) != newState) {
            world.m_46597_(pos, (BlockState)state.m_61124_(WINDOWSTATE, (Comparable)((Object)newState)));
            this.toggleAdjacentWindows(world, pos.m_7494_(), facing, newState, depth + 1, maxDepth);
            this.toggleAdjacentWindows(world, pos.m_7495_(), facing, newState, depth + 1, maxDepth);
        }
    }

    private void lockWindow(Level world, BlockPos pos, boolean targetOpen, Direction targetDirection, int depth) {
        if (depth <= 0) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == this) {
            boolean isLocked = state.m_61143_(WINDOWSTATE) == WindowState.LOCKED;
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            if (isLocked != targetOpen && direction.equals((Object)targetDirection)) {
                world.m_46597_(pos, (BlockState)state.m_61124_(WINDOWSTATE, (Comparable)((Object)(targetOpen ? WindowState.LOCKED : WindowState.CLOSED))));
                Direction[] directions = direction.m_122434_() == Direction.Axis.X ? new Direction[]{Direction.SOUTH, Direction.NORTH} : new Direction[]{Direction.EAST, Direction.WEST};
                for (Direction dir : directions) {
                    this.lockWindow(world, pos.m_121945_(dir), targetOpen, targetDirection, depth - 2);
                }
                for (int y = 1; y <= 2; ++y) {
                    this.lockWindow(world, pos.m_6630_(y), targetOpen, targetDirection, depth - 2);
                    this.lockWindow(world, pos.m_6625_(y), targetOpen, targetDirection, depth - 2);
                }
            }
        }
    }

    public static enum WindowState implements StringRepresentable
    {
        CLOSED("closed"),
        OPEN_LEFT("open_left"),
        OPEN_RIGHT("open_right"),
        LOCKED("locked");

        private final String name;

        private WindowState(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

