/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.registry;

import com.glodblock.github.glodium.Glodium;
import it.unimi.dsi.fastutil.objects.Object2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.commons.lang3.tuple.Pair;

public class RegistryHandler {
    protected final String id;
    protected final List<Pair<String, Block>> blocks = new ArrayList<Pair<String, Block>>();
    protected final List<Pair<String, Item>> items = new ArrayList<Pair<String, Item>>();
    protected final List<Pair<String, BlockEntityType<?>>> tiles = new ArrayList();
    protected final Object2ReferenceMap<String, Function<Block, Item>> itemBlocks = new Object2ReferenceOpenHashMap();

    public RegistryHandler(String modid) {
        this.id = modid;
    }

    public void block(String name, Block block) {
        this.blocks.add((Pair<String, Block>)Pair.of((Object)name, (Object)block));
    }

    public void block(String name, Block block, Function<Block, Item> itemWrapper) {
        this.block(name, block);
        this.itemBlocks.put((Object)name, itemWrapper);
    }

    public void item(String name, Item item) {
        this.items.add((Pair<String, Item>)Pair.of((Object)name, (Object)item));
    }

    public void tile(String name, BlockEntityType<?> type) {
        this.tiles.add(Pair.of((Object)name, type));
    }

    @SubscribeEvent
    public final void runRegister(RegisterEvent event) {
        if (event.getRegistryKey().equals((Object)Registries.f_256747_)) {
            this.register(event);
        }
    }

    public void register(RegisterEvent event) {
        this.onRegisterBlocks();
        this.onRegisterItems();
        this.onRegisterTileEntities();
    }

    protected void onRegisterBlocks() {
        for (Pair<String, Block> entry : this.blocks) {
            String key = (String)entry.getLeft();
            Block block = (Block)entry.getRight();
            ForgeRegistries.BLOCKS.register(Glodium.id(this.id, key), (Object)block);
        }
    }

    protected void onRegisterItems() {
        for (Pair<String, Block> pair : this.blocks) {
            if (this.itemBlocks.containsKey(pair.getLeft())) {
                ForgeRegistries.ITEMS.register(Glodium.id(this.id, (String)pair.getLeft()), (Object)((Item)((Function)this.itemBlocks.get(pair.getLeft())).apply((Block)pair.getRight())));
                continue;
            }
            ForgeRegistries.ITEMS.register(Glodium.id(this.id, (String)pair.getLeft()), (Object)new BlockItem((Block)pair.getRight(), new Item.Properties()));
        }
        for (Pair<String, Block> pair : this.items) {
            ForgeRegistries.ITEMS.register(Glodium.id(this.id, (String)pair.getLeft()), (Object)((Item)pair.getRight()));
        }
    }

    protected void onRegisterTileEntities() {
        for (Pair<String, BlockEntityType<?>> entry : this.tiles) {
            ForgeRegistries.BLOCK_ENTITY_TYPES.register(Glodium.id(this.id, (String)entry.getLeft()), (Object)((BlockEntityType)entry.getRight()));
        }
    }
}

