/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.glodium.reflect.moon;

import com.glodblock.github.glodium.Glodium;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jetbrains.annotations.ApiStatus;
import sun.misc.Unsafe;

@ApiStatus.Internal
public final class Moon {
    private static final Unsafe UNSAFE = Moon.unsafe();
    private static final MethodHandles.Lookup LOOKUP = Moon.lookup();

    private static Unsafe unsafe() {
        try {
            Field theSafe = Unsafe.class.getDeclaredField("theUnsafe");
            theSafe.setAccessible(true);
            return (Unsafe)theSafe.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    private static MethodHandles.Lookup lookup() {
        try {
            Field field = MethodHandles.Lookup.class.getDeclaredField("IMPL_LOOKUP");
            long offset = UNSAFE.staticFieldOffset(field);
            return (MethodHandles.Lookup)UNSAFE.getObject(MethodHandles.Lookup.class, offset);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static void removeFinal(Field field) {
        try {
            VarHandle m = LOOKUP.findVarHandle(Field.class, "modifiers", Integer.TYPE);
            int modify = field.getModifiers();
            m.set(field, modify & 0xFFFFFFEF);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Glodium.LOGGER.error(e.getMessage());
        }
    }

    public static void setField(Field field, Object owner, Object value) throws IllegalAccessException {
        if (Modifier.isStatic(field.getModifiers())) {
            LOOKUP.ensureInitialized(field.getDeclaringClass());
            Moon.putHelper(field.getType(), UNSAFE.staticFieldBase(field), UNSAFE.staticFieldOffset(field), value);
        } else {
            Moon.putHelper(field.getType(), owner, UNSAFE.objectFieldOffset(field), value);
        }
    }

    public static Object getField(Field field, Object owner) throws IllegalAccessException {
        if (Modifier.isStatic(field.getModifiers())) {
            LOOKUP.ensureInitialized(field.getDeclaringClass());
            return Moon.getHelper(field.getType(), UNSAFE.staticFieldBase(field), UNSAFE.staticFieldOffset(field));
        }
        return Moon.getHelper(field.getType(), owner, UNSAFE.objectFieldOffset(field));
    }

    private static void putHelper(Class<?> clazz, Object owner, long offset, Object value) {
        if (clazz == Integer.TYPE) {
            UNSAFE.putInt(owner, offset, (Integer)value);
        } else if (clazz == Short.TYPE) {
            UNSAFE.putShort(owner, offset, (Short)value);
        } else if (clazz == Byte.TYPE) {
            UNSAFE.putByte(owner, offset, (Byte)value);
        } else if (clazz == Long.TYPE) {
            UNSAFE.putLong(owner, offset, (Long)value);
        } else if (clazz == Float.TYPE) {
            UNSAFE.putFloat(owner, offset, ((Float)value).floatValue());
        } else if (clazz == Double.TYPE) {
            UNSAFE.putDouble(owner, offset, (Double)value);
        } else if (clazz == Boolean.TYPE) {
            UNSAFE.putBoolean(owner, offset, (Boolean)value);
        } else if (clazz == Character.TYPE) {
            UNSAFE.putChar(owner, offset, ((Character)value).charValue());
        } else {
            UNSAFE.putObject(owner, offset, value);
        }
    }

    private static Object getHelper(Class<?> clazz, Object owner, long offset) {
        if (clazz == Integer.TYPE) {
            return UNSAFE.getInt(owner, offset);
        }
        if (clazz == Short.TYPE) {
            return UNSAFE.getShort(owner, offset);
        }
        if (clazz == Byte.TYPE) {
            return UNSAFE.getByte(owner, offset);
        }
        if (clazz == Long.TYPE) {
            return UNSAFE.getLong(owner, offset);
        }
        if (clazz == Float.TYPE) {
            return Float.valueOf(UNSAFE.getFloat(owner, offset));
        }
        if (clazz == Double.TYPE) {
            return UNSAFE.getDouble(owner, offset);
        }
        if (clazz == Boolean.TYPE) {
            return UNSAFE.getBoolean(owner, offset);
        }
        if (clazz == Character.TYPE) {
            return Character.valueOf(UNSAFE.getChar(owner, offset));
        }
        return UNSAFE.getObject(owner, offset);
    }
}

