/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.block.tile.ModularRouterBlockEntity;
import me.desht.modularrouters.client.util.ClientUtil;
import me.desht.modularrouters.core.ModBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkEvent;

public class RouterUpgradesSyncMessage {
    private final BlockPos pos;
    private final ItemStackHandler handler;

    public RouterUpgradesSyncMessage(ModularRouterBlockEntity router) {
        this.pos = router.m_58899_();
        IItemHandler upgradesHandler = router.getUpgrades();
        this.handler = new ItemStackHandler(upgradesHandler.getSlots());
        for (int i = 0; i < upgradesHandler.getSlots(); ++i) {
            this.handler.setStackInSlot(i, upgradesHandler.getStackInSlot(i));
        }
    }

    public RouterUpgradesSyncMessage(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.handler = new ItemStackHandler();
        this.handler.deserializeNBT(buf.m_130260_());
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.m_130079_(this.handler.serializeNBT());
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Level w = ClientUtil.theClientWorld();
            if (w != null) {
                w.m_141902_(this.pos, (BlockEntityType)ModBlockEntities.MODULAR_ROUTER.get()).ifPresent(router -> router.setUpgradesFrom((IItemHandler)this.handler));
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

