/*
 * Decompiled with CFR 0.152.
 */
package me.desht.modularrouters.network;

import java.util.function.Supplier;
import me.desht.modularrouters.item.module.ModuleItem;
import me.desht.modularrouters.item.smartfilter.SmartFilterItem;
import me.desht.modularrouters.util.MFLocator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class OpenGuiMessage {
    private final Operation operation;
    private final MFLocator locator;

    private OpenGuiMessage(Operation operation, MFLocator locator) {
        this.operation = operation;
        this.locator = locator;
    }

    OpenGuiMessage(FriendlyByteBuf buf) {
        this.operation = (Operation)buf.m_130066_(Operation.class);
        this.locator = MFLocator.fromBuffer(buf);
    }

    public static OpenGuiMessage openRouter(MFLocator locator) {
        return new OpenGuiMessage(Operation.ROUTER, locator);
    }

    public static OpenGuiMessage openModuleInHand(MFLocator locator) {
        return new OpenGuiMessage(Operation.MODULE_HELD, locator);
    }

    public static OpenGuiMessage openModuleInRouter(MFLocator locator) {
        return new OpenGuiMessage(Operation.MODULE_INSTALLED, locator);
    }

    public static OpenGuiMessage openFilterInHeldModule(MFLocator locator) {
        return new OpenGuiMessage(Operation.FILTER_HELD, locator);
    }

    public static OpenGuiMessage openFilterInInstalledModule(MFLocator locator) {
        return new OpenGuiMessage(Operation.FILTER_INSTALLED, locator);
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130068_((Enum)this.operation);
        this.locator.writeBuf(buf);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
            if (player != null) {
                switch (this.operation) {
                    case ROUTER: {
                        this.locator.getRouter(player.m_20193_()).ifPresent(router -> NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)router, (BlockPos)this.locator.routerPos));
                        break;
                    }
                    case MODULE_HELD: {
                        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new ModuleItem.ModuleMenuProvider((Player)player, this.locator), this.locator::writeBuf);
                        break;
                    }
                    case MODULE_INSTALLED: {
                        this.locator.getRouter(player.m_20193_()).ifPresent(router -> NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new ModuleItem.ModuleMenuProvider((Player)player, this.locator), this.locator::writeBuf));
                        break;
                    }
                    case FILTER_HELD: {
                        NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SmartFilterItem.FilterMenuProvider((Player)player, this.locator), this.locator::writeBuf);
                        break;
                    }
                    case FILTER_INSTALLED: {
                        this.locator.getRouter(player.m_20193_()).ifPresent(router -> NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new SmartFilterItem.FilterMenuProvider((Player)player, this.locator), this.locator::writeBuf));
                    }
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static enum Operation {
        ROUTER,
        MODULE_HELD,
        MODULE_INSTALLED,
        FILTER_HELD,
        FILTER_INSTALLED;

    }
}

