/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.core;

import com.aizistral.nochatreports.common.core.ServerSafetyLevel;
import com.aizistral.nochatreports.common.gui.UnsafeServerScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class ServerSafetyState {
    private static final List<Runnable> RESET_ACTIONS = new ArrayList<Runnable>();
    private static final List<Runnable> SIGNING_ACTIONS = new ArrayList<Runnable>();
    private static final AtomicBoolean ALLOW_CHAT_SIGNING = new AtomicBoolean(false);
    private static volatile ServerSafetyLevel current = ServerSafetyLevel.UNDEFINED;
    private static volatile ServerAddress lastServer = null;

    public static void updateCurrent(ServerSafetyLevel level) {
        current = level;
    }

    public static ServerSafetyLevel getCurrent() {
        return current;
    }

    public static boolean allowChatSigning() {
        return ALLOW_CHAT_SIGNING.get();
    }

    public static CompletableFuture<Void> setAllowChatSigning(boolean allow) {
        if (ALLOW_CHAT_SIGNING.compareAndSet(!allow, allow) && Minecraft.m_91087_().f_91074_ != null) {
            ClientPacketListener connection = Minecraft.m_91087_().f_91074_.f_108617_;
            if (allow && connection.f_252517_ == null) {
                return Minecraft.m_91087_().m_231465_().m_252904_().thenAcceptAsync(optional -> optional.ifPresent(profileKeyPair -> {
                    connection.m_260951_(profileKeyPair);
                    SIGNING_ACTIONS.forEach(Runnable::run);
                    SIGNING_ACTIONS.clear();
                }), (Executor)Minecraft.m_91087_());
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public static void toggleChatSigning() {
        ServerSafetyState.setAllowChatSigning(!ALLOW_CHAT_SIGNING.get());
    }

    public static boolean isOnRealms() {
        return current == ServerSafetyLevel.REALMS;
    }

    public static boolean isInSingleplayer() {
        return current == ServerSafetyLevel.SINGLEPLAYER;
    }

    public static boolean isDetermined() {
        return current != ServerSafetyLevel.UNINTRUSIVE && current != ServerSafetyLevel.UNDEFINED && current != ServerSafetyLevel.UNKNOWN;
    }

    @Nullable
    public static ServerAddress getLastServer() {
        return lastServer;
    }

    public static void setLastServer(@Nullable ServerAddress address) {
        lastServer = address;
    }

    public static void scheduleResetAction(Runnable action) {
        RESET_ACTIONS.add(action);
    }

    public static void scheduleSigningAction(Runnable action) {
        SIGNING_ACTIONS.add(action);
    }

    public static void reset() {
        lastServer = null;
        current = ServerSafetyLevel.UNDEFINED;
        ALLOW_CHAT_SIGNING.set(false);
        UnsafeServerScreen.setHideThisSession(false);
        RESET_ACTIONS.forEach(Runnable::run);
        RESET_ACTIONS.clear();
        SIGNING_ACTIONS.clear();
    }
}

