/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.inventory;

import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntAVLTreeSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Map;
import java.util.PrimitiveIterator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.cyclops.cyclopscore.inventory.IndexedSlotlessItemHandlerWrapper;
import org.cyclops.cyclopscore.inventory.LargeInventory;

public class IndexedInventory
extends LargeInventory
implements IndexedSlotlessItemHandlerWrapper.IInventoryIndexReference {
    private final Map<Item, Int2ObjectMap<ItemStack>> index = Maps.newIdentityHashMap();
    private IntSet emptySlots = new IntAVLTreeSet();
    private IntSet nonEmptySlots = new IntAVLTreeSet();

    public IndexedInventory() {
        this(0, 0);
    }

    public IndexedInventory(int size, int stackLimit) {
        super(size, stackLimit);
        this.createIndex();
    }

    protected void createIndex() {
        this.index.clear();
        this.nonEmptySlots.clear();
        this.emptySlots.clear();
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack itemStack = this.m_8020_(i);
            if (!itemStack.m_41619_()) {
                Int2ObjectOpenHashMap stacks = this.index.get(itemStack.m_41720_());
                if (stacks == null) {
                    stacks = new Int2ObjectOpenHashMap();
                    this.index.put(itemStack.m_41720_(), (Int2ObjectMap<ItemStack>)stacks);
                }
                stacks.put(i, (Object)itemStack);
                this.nonEmptySlots.add(i);
                continue;
            }
            this.emptySlots.add(i);
        }
    }

    @Override
    public void readFromNBT(CompoundTag data, String tag) {
        super.readFromNBT(data, tag);
        this.createIndex();
    }

    @Override
    public void m_6836_(int slotId, ItemStack itemStack) {
        Int2ObjectMap<ItemStack> stacks;
        ItemStack oldStack = this.m_8020_(slotId);
        boolean wasEmpty = oldStack.m_41619_();
        boolean isEmpty = itemStack.m_41619_();
        if (!oldStack.m_41619_()) {
            stacks = this.index.get(oldStack.m_41720_());
            if (stacks != null) {
                stacks.remove(slotId);
            }
            if (stacks.isEmpty()) {
                this.index.remove(oldStack.m_41720_());
            }
        }
        if (!itemStack.m_41619_()) {
            stacks = this.index.get(itemStack.m_41720_());
            if (stacks == null) {
                stacks = new Int2ObjectOpenHashMap();
                this.index.put(itemStack.m_41720_(), stacks);
            }
            stacks.put(slotId, (Object)itemStack);
        }
        super.m_6836_(slotId, itemStack);
        if (wasEmpty && !isEmpty) {
            this.emptySlots.remove(slotId);
            this.nonEmptySlots.add(slotId);
        }
        if (!wasEmpty && isEmpty) {
            this.emptySlots.add(slotId);
            this.nonEmptySlots.remove(slotId);
        }
        if (this.nonEmptySlots.size() + this.emptySlots.size() != this.m_6643_()) {
            throw new IllegalStateException(String.format("Indexed inventory at inconsistent state %s %s %s (slot: %s).", this.nonEmptySlots, this.emptySlots, this.m_6643_(), slotId));
        }
    }

    @Override
    public void m_6211_() {
        super.m_6211_();
        this.index.clear();
    }

    @Override
    public int getInventoryReferenceStackLimit() {
        return this.m_6893_();
    }

    @Override
    public Map<Item, Int2ObjectMap<ItemStack>> getIndex() {
        return this.index;
    }

    @Override
    public PrimitiveIterator.OfInt getEmptySlots() {
        return new IndexedSlotlessItemHandlerWrapper.WrappedIntIterator(this.emptySlots.iterator());
    }

    @Override
    public PrimitiveIterator.OfInt getNonEmptySlots() {
        return new IndexedSlotlessItemHandlerWrapper.WrappedIntIterator(this.nonEmptySlots.iterator());
    }
}

