/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item.gear;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.ModList;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreArmor;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.client.util.GearClientHelper;
import net.silentchaos512.gear.compat.caelus.CaelusCompat;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.gear.util.TraitHelper;

public class GearElytraItem
extends ElytraItem
implements ICoreArmor {
    private static final UUID ARMOR_UUID = UUID.fromString("f099f401-82f6-4565-a0b5-fd464f2dc72c");
    private static final List<PartType> REQUIRED_PARTS = ImmutableList.of((Object)PartType.MAIN, (Object)PartType.BINDING);
    private static final Set<ItemStat> RELEVANT_STATS = ImmutableSet.of((Object)ItemStats.DURABILITY, (Object)ItemStats.REPAIR_EFFICIENCY, (Object)ItemStats.ARMOR);
    private static final Set<ItemStat> EXCLUDED_STATS = ImmutableSet.of((Object)ItemStats.REPAIR_VALUE, (Object)ItemStats.HARVEST_SPEED, (Object)ItemStats.REACH_DISTANCE, (Object)ItemStats.MELEE_DAMAGE, (Object)ItemStats.MAGIC_DAMAGE, (Object)ItemStats.ATTACK_SPEED, (Object[])new ItemStat[]{ItemStats.ATTACK_REACH, ItemStats.RANGED_DAMAGE, ItemStats.RANGED_SPEED});

    public GearElytraItem(Item.Properties builder) {
        super(builder.m_41503_(100));
    }

    @Override
    public GearType getGearType() {
        return GearType.ELYTRA;
    }

    @Override
    public Set<ItemStat> getRelevantStats(ItemStack stack) {
        return RELEVANT_STATS;
    }

    @Override
    public Set<ItemStat> getExcludedStats(ItemStack stack) {
        return EXCLUDED_STATS;
    }

    @Override
    public boolean isValidSlot(String slot) {
        return EquipmentSlot.CHEST.m_20751_().equalsIgnoreCase(slot) || "back".equalsIgnoreCase(slot);
    }

    @Override
    public Collection<PartType> getRequiredParts() {
        return REQUIRED_PARTS;
    }

    @Override
    public boolean supportsPart(ItemStack gear, PartData part) {
        PartType type = part.getType();
        boolean canAdd = part.get().canAddToGear(gear, part);
        boolean supported = this.requiresPartOfType(part.getType()) && canAdd || canAdd;
        return type == PartType.MAIN && supported || type == PartType.LINING || supported;
    }

    @Override
    public boolean hasTexturesFor(PartType partType) {
        return partType == PartType.MAIN || partType == PartType.BINDING;
    }

    @Override
    public float getRepairModifier(ItemStack stack) {
        return this.getGearType().getArmorDurabilityMultiplier();
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)this.getGearType().getArmorDurabilityMultiplier() * this.getStatInt(stack, this.getDurabilityStat());
    }

    public void setDamage(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return;
        }
        if (!Config.Common.isLoaded() || !((Boolean)Config.Common.gearBreaksPermanently.get()).booleanValue()) {
            damage = Mth.m_14045_((int)damage, (int)0, (int)this.getMaxDamage(stack));
        }
        super.setDamage(stack, damage);
    }

    public <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        return GearHelper.damageItem(stack, amount, entity, t -> {
            GearHelper.onBroken(stack, t instanceof Player ? (Player)t : null, this.getEquipmentSlot(stack));
            onBroken.accept(t);
        });
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return GearHelper.getIsRepairable(toRepair, repair);
    }

    public void onArmorTick(ItemStack stack, Level world, Player player) {
        GearHelper.inventoryTick(stack, world, (Entity)player, 0, true);
    }

    public void m_6883_(ItemStack stack, Level worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        GearHelper.inventoryTick(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return TraitHelper.hasTrait(stack, Const.Traits.BRILLIANT);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.createElytraProvider(stack, this);
        }
        return super.initCapabilities(stack, nbt);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        if (this.isValidSlot(slot.m_20751_())) {
            this.addAttributes(slot.m_20751_(), stack, (Multimap<Attribute, AttributeModifier>)multimap, true);
        }
        return multimap;
    }

    public void addAttributes(String slot, ItemStack stack, Multimap<Attribute, AttributeModifier> multimap, boolean includeArmor) {
        if (GearHelper.isBroken(stack)) {
            return;
        }
        float armor = this.getStat(stack, ItemStats.ARMOR);
        if (armor > 0.0f && includeArmor) {
            multimap.put((Object)Attributes.f_22284_, (Object)new AttributeModifier(ARMOR_UUID, "Elytra armor modifier", (double)armor, AttributeModifier.Operation.ADDITION));
        }
        GearHelper.getAttributeModifiers(slot, stack, multimap, false);
        CaelusCompat.tryAddFlightAttribute(multimap);
    }

    public Component m_7626_(ItemStack stack) {
        return GearHelper.getDisplayName(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        if (!ModList.get().isLoaded("caelus")) {
            tooltip.add((Component)TextUtil.misc("caelusNotInstalled", new Object[0]).m_130940_(ChatFormatting.RED));
        }
        GearClientHelper.addInformation(stack, worldIn, tooltip, flagIn);
    }

    public int m_142158_(ItemStack stack) {
        return GearHelper.getBarWidth(stack);
    }

    public int m_142159_(ItemStack stack) {
        return GearHelper.getBarColor(stack);
    }
}

