/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.ApiConst;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.block.PhantomLight;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.item.FakeItemUseContext;
import net.silentchaos512.lib.util.NameUtils;

public class BlockPlacerTrait
extends SimpleTrait {
    public static final ITraitSerializer<BlockPlacerTrait> SERIALIZER = new SimpleTrait.Serializer<BlockPlacerTrait>(ApiConst.BLOCK_PLACER_TRAIT_ID, BlockPlacerTrait::new, BlockPlacerTrait::readJson, BlockPlacerTrait::read, BlockPlacerTrait::write);
    private Block block;
    private int damageOnUse;
    private int cooldown;
    private SoundEvent sound = SoundEvents.f_12019_;
    private float soundVolume = 1.0f;
    private float soundPitch = 1.0f;

    public BlockPlacerTrait(ResourceLocation name) {
        super(name, SERIALIZER);
    }

    @Override
    public InteractionResult onItemUse(UseOnContext context, int traitLevel) {
        ItemStack stack = context.m_43722_();
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        if (!(world.f_46443_ || this.damageOnUse >= 1 && stack.m_41773_() >= stack.m_41776_() - this.damageOnUse - 1)) {
            ItemStack fakeBlockStack = new ItemStack((ItemLike)this.block);
            InteractionResult result = fakeBlockStack.m_41661_((UseOnContext)new FakeItemUseContext(context, fakeBlockStack));
            if (result.m_19077_()) {
                if (this.damageOnUse > 0) {
                    GearHelper.attemptDamage(stack, this.damageOnUse, (LivingEntity)context.m_43723_(), context.m_43724_());
                }
                if (this.sound != null) {
                    float pitch = (float)((double)this.soundPitch * (1.0 + 0.05 * SilentGear.RANDOM.nextGaussian()));
                    world.m_5594_(null, pos, this.sound, SoundSource.BLOCKS, this.soundVolume, pitch);
                }
                if (this.cooldown > 0 && context.m_43723_() != null) {
                    context.m_43723_().m_36335_().m_41524_(stack.m_41720_(), this.cooldown);
                }
            }
            return result;
        }
        for (int i = 0; i < 5; ++i) {
            PhantomLight.spawnParticle((LevelAccessor)world, pos.m_121945_(context.m_43719_()), SilentGear.RANDOM_SOURCE);
        }
        return InteractionResult.SUCCESS;
    }

    private static void readJson(BlockPlacerTrait trait, JsonObject json) {
        ResourceLocation blockId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"block"));
        trait.block = (Block)ForgeRegistries.BLOCKS.getValue(blockId);
        if (trait.block == null) {
            throw new JsonParseException("Unknown block: " + blockId);
        }
        trait.damageOnUse = GsonHelper.m_13927_((JsonObject)json, (String)"damage_on_use");
        trait.cooldown = GsonHelper.m_13824_((JsonObject)json, (String)"cooldown", (int)0);
        ResourceLocation soundId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"sound"));
        trait.sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(soundId);
        if (trait.sound == null) {
            throw new JsonParseException("Unknown sound: " + soundId);
        }
        trait.soundVolume = GsonHelper.m_13915_((JsonObject)json, (String)"sound_volume");
        trait.soundPitch = GsonHelper.m_13915_((JsonObject)json, (String)"sound_pitch");
    }

    private static void read(BlockPlacerTrait trait, FriendlyByteBuf buffer) {
        trait.block = (Block)ForgeRegistries.BLOCKS.getValue(buffer.m_130281_());
        trait.damageOnUse = buffer.m_130242_();
        trait.cooldown = buffer.m_130242_();
        trait.sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(buffer.m_130281_());
        trait.soundVolume = buffer.readFloat();
        trait.soundPitch = buffer.readFloat();
    }

    private static void write(BlockPlacerTrait trait, FriendlyByteBuf buffer) {
        buffer.m_130085_(NameUtils.fromBlock((Block)trait.block));
        buffer.m_130130_(trait.damageOnUse);
        buffer.m_130130_(trait.cooldown);
        buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.SOUND_EVENTS.getKey((Object)trait.sound)));
        buffer.writeFloat(trait.soundVolume);
        buffer.writeFloat(trait.soundPitch);
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        Collection<String> ret = super.getExtraWikiLines();
        ret.add("  - Places: " + NameUtils.fromBlock((Block)this.block));
        ret.add("  - Durability Cost: " + this.damageOnUse);
        if (this.cooldown > 0) {
            ret.add("  - Cooldown: " + this.cooldown);
        }
        return ret;
    }
}

