/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.item.ItemStack;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.util.GearData;

public final class ColorUtils {
    public static final Cache<String, Map<PartType, Integer>> GEAR_COLOR_CACHE = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();

    private ColorUtils() {
    }

    public static int getBlendedColor(ICoreItem item, IPartData part, Collection<? extends IMaterialInstance> materials, int layer) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int i = 0;
        for (IMaterialInstance iMaterialInstance : materials) {
            IMaterialDisplay model = iMaterialInstance.getDisplayProperties();
            int color = model.getLayerColor(item.getGearType(), part, iMaterialInstance, layer);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = (materials.size() - i) * (materials.size() - i);
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
            ++i;
        }
        return ColorUtils.blendColors(componentSums, maxColorSum, colorCount);
    }

    public static int getBlendedColor(CompoundPartItem item, Collection<? extends IMaterialInstance> materials, int layer) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int i = 0;
        for (IMaterialInstance iMaterialInstance : materials) {
            IMaterialDisplay model = iMaterialInstance.getDisplayProperties();
            List<MaterialLayer> layers = model.getLayerList(item.getGearType(), item.getPartType(), iMaterialInstance).getLayers();
            if (layers.size() <= layer) continue;
            int color = model.getLayerColor(item.getGearType(), item.getPartType(), iMaterialInstance, layer);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = item.getColorWeight(i, materials.size());
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
            ++i;
        }
        return ColorUtils.blendColors(componentSums, maxColorSum, colorCount);
    }

    public static int getBlendedColor(CompoundMaterialItem item, Collection<? extends IMaterialInstance> materials, int layer) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int i = 0;
        for (IMaterialInstance iMaterialInstance : materials) {
            IMaterialDisplay model = iMaterialInstance.getDisplayProperties();
            List<MaterialLayer> layers = model.getLayerList(GearType.ALL, PartType.MAIN, iMaterialInstance).getLayers();
            if (layers.size() <= layer) continue;
            int color = layers.get(layer).getColor();
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = item.getColorWeight(i, materials.size());
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
            ++i;
        }
        return ColorUtils.blendColors(componentSums, maxColorSum, colorCount);
    }

    private static int blendColors(int[] componentSums, float maxColorSum, int colorCount) {
        if (colorCount > 0) {
            int r = componentSums[0] / colorCount;
            int g = componentSums[1] / colorCount;
            int b = componentSums[2] / colorCount;
            float maxAverage = maxColorSum / (float)colorCount;
            float max = Math.max(r, Math.max(g, b));
            r = (int)((float)r * maxAverage / max);
            g = (int)((float)g * maxAverage / max);
            b = (int)((float)b * maxAverage / max);
            int finalColor = (r << 8) + g;
            finalColor = (finalColor << 8) + b;
            return finalColor;
        }
        return 0xFFFFFF;
    }

    public static int getBlendedColor(ItemStack stack, PartType partType) {
        if (ColorUtils.hasCachedColor(stack, partType, 0)) {
            return ColorUtils.getCachedColor(stack, partType, 0);
        }
        List<PartData> list = GearData.getConstructionParts(stack).getPartsOfType(partType);
        if (!list.isEmpty()) {
            int color = ColorUtils.getBlendedColor(stack, list) & 0xFFFFFF;
            ColorUtils.setCachedColor(stack, partType, 0, color);
            return color;
        }
        return 0xFFFFFF;
    }

    private static int getBlendedColor(ItemStack gear, List<PartData> parts) {
        int[] componentSums = new int[3];
        int maxColorSum = 0;
        int colorCount = 0;
        int partCount = parts.size();
        for (int i = 0; i < partCount; ++i) {
            PartData part = parts.get(i);
            int color = part.get().getColor(part, gear, 0, 0);
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            int colorWeight = (partCount - i) * (partCount - i);
            for (int j = 0; j < colorWeight; ++j) {
                maxColorSum += Math.max(r, Math.max(g, b));
                componentSums[0] = componentSums[0] + r;
                componentSums[1] = componentSums[1] + g;
                componentSums[2] = componentSums[2] + b;
                ++colorCount;
            }
        }
        if (colorCount > 0) {
            int r = componentSums[0] / colorCount;
            int g = componentSums[1] / colorCount;
            int b = componentSums[2] / colorCount;
            float maxAverage = (float)maxColorSum / (float)colorCount;
            float max = Math.max(r, Math.max(g, b));
            r = (int)((float)r * maxAverage / max);
            g = (int)((float)g * maxAverage / max);
            b = (int)((float)b * maxAverage / max);
            int finalColor = (r << 8) + g;
            finalColor = (finalColor << 8) + b;
            return finalColor;
        }
        return 0xFFFFFF;
    }

    public static boolean hasCachedColor(ItemStack stack, PartType partType, int animationFrame) {
        String modelKey = GearData.getModelKey(stack, animationFrame);
        Map map = (Map)GEAR_COLOR_CACHE.getIfPresent((Object)modelKey);
        return map != null && map.containsKey(partType);
    }

    public static int getCachedColor(ItemStack stack, PartType partType, int animationFrame) {
        Map partTypeMap = (Map)GEAR_COLOR_CACHE.getIfPresent((Object)GearData.getModelKey(stack, animationFrame));
        if (partTypeMap != null) {
            return partTypeMap.getOrDefault(partType, 0xFFFFFF);
        }
        return 0xFFFFFF;
    }

    public static void setCachedColor(ItemStack stack, PartType partType, int animationFrame, int color) {
        String modelKey = GearData.getModelKey(stack, animationFrame);
        HashMap<PartType, Integer> map = (HashMap<PartType, Integer>)GEAR_COLOR_CACHE.getIfPresent((Object)modelKey);
        if (map == null) {
            map = new HashMap<PartType, Integer>();
            GEAR_COLOR_CACHE.put((Object)modelKey, map);
        }
        map.put(partType, color);
    }
}

