/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.lib.compat.theoneprobe.TOPInfoProvider;
import mcjty.xnet.compat.XNetTOPDriver;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.facade.IFacadeSupport;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraftforge.client.model.data.ModelProperty;

public abstract class GenericCableBlock
extends Block
implements TOPInfoProvider,
SimpleWaterloggedBlock {
    public static final EnumProperty<ConnectorType> NORTH = EnumProperty.m_61587_((String)"north", ConnectorType.class);
    public static final EnumProperty<ConnectorType> SOUTH = EnumProperty.m_61587_((String)"south", ConnectorType.class);
    public static final EnumProperty<ConnectorType> WEST = EnumProperty.m_61587_((String)"west", ConnectorType.class);
    public static final EnumProperty<ConnectorType> EAST = EnumProperty.m_61587_((String)"east", ConnectorType.class);
    public static final EnumProperty<ConnectorType> UP = EnumProperty.m_61587_((String)"up", ConnectorType.class);
    public static final EnumProperty<ConnectorType> DOWN = EnumProperty.m_61587_((String)"down", ConnectorType.class);
    public static final EnumProperty<CableColor> COLOR = EnumProperty.m_61587_((String)"color", CableColor.class);
    public static final ModelProperty<BlockState> FACADEID = new ModelProperty();
    private static VoxelShape[] shapeCache = null;
    private static final VoxelShape SHAPE_CABLE_NORTH = Shapes.m_83048_((double)0.4, (double)0.4, (double)0.0, (double)0.6, (double)0.6, (double)0.4);
    private static final VoxelShape SHAPE_CABLE_SOUTH = Shapes.m_83048_((double)0.4, (double)0.4, (double)0.6, (double)0.6, (double)0.6, (double)1.0);
    private static final VoxelShape SHAPE_CABLE_WEST = Shapes.m_83048_((double)0.0, (double)0.4, (double)0.4, (double)0.4, (double)0.6, (double)0.6);
    private static final VoxelShape SHAPE_CABLE_EAST = Shapes.m_83048_((double)0.6, (double)0.4, (double)0.4, (double)1.0, (double)0.6, (double)0.6);
    private static final VoxelShape SHAPE_CABLE_UP = Shapes.m_83048_((double)0.4, (double)0.6, (double)0.4, (double)0.6, (double)1.0, (double)0.6);
    private static final VoxelShape SHAPE_CABLE_DOWN = Shapes.m_83048_((double)0.4, (double)0.0, (double)0.4, (double)0.6, (double)0.4, (double)0.6);
    private static final VoxelShape SHAPE_BLOCK_NORTH = Shapes.m_83048_((double)0.2, (double)0.2, (double)0.0, (double)0.8, (double)0.8, (double)0.1);
    private static final VoxelShape SHAPE_BLOCK_SOUTH = Shapes.m_83048_((double)0.2, (double)0.2, (double)0.9, (double)0.8, (double)0.8, (double)1.0);
    private static final VoxelShape SHAPE_BLOCK_WEST = Shapes.m_83048_((double)0.0, (double)0.2, (double)0.2, (double)0.1, (double)0.8, (double)0.8);
    private static final VoxelShape SHAPE_BLOCK_EAST = Shapes.m_83048_((double)0.9, (double)0.2, (double)0.2, (double)1.0, (double)0.8, (double)0.8);
    private static final VoxelShape SHAPE_BLOCK_UP = Shapes.m_83048_((double)0.2, (double)0.9, (double)0.2, (double)0.8, (double)1.0, (double)0.8);
    private static final VoxelShape SHAPE_BLOCK_DOWN = Shapes.m_83048_((double)0.2, (double)0.0, (double)0.2, (double)0.8, (double)0.1, (double)0.8);
    private final CableBlockType type;

    public GenericCableBlock(CableBlockType type) {
        super(BlockBehaviour.Properties.m_284310_().m_60978_(1.0f).m_60918_(SoundType.f_56743_).m_60955_());
        this.makeShapes();
        this.type = type;
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
    }

    private int calculateShapeIndex(ConnectorType north, ConnectorType south, ConnectorType west, ConnectorType east, ConnectorType up, ConnectorType down) {
        int l = ConnectorType.values().length;
        return ((((south.ordinal() * l + north.ordinal()) * l + west.ordinal()) * l + east.ordinal()) * l + up.ordinal()) * l + down.ordinal();
    }

    private void makeShapes() {
        if (shapeCache == null) {
            int length = ConnectorType.values().length;
            shapeCache = new VoxelShape[length * length * length * length * length * length];
            for (ConnectorType up : ConnectorType.VALUES) {
                for (ConnectorType down : ConnectorType.VALUES) {
                    for (ConnectorType north : ConnectorType.VALUES) {
                        for (ConnectorType south : ConnectorType.VALUES) {
                            for (ConnectorType east : ConnectorType.VALUES) {
                                for (ConnectorType west : ConnectorType.VALUES) {
                                    int idx = this.calculateShapeIndex(north, south, west, east, up, down);
                                    GenericCableBlock.shapeCache[idx] = this.makeShape(north, south, west, east, up, down);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private VoxelShape makeShape(ConnectorType north, ConnectorType south, ConnectorType west, ConnectorType east, ConnectorType up, ConnectorType down) {
        VoxelShape shape = Shapes.m_83048_((double)0.4, (double)0.4, (double)0.4, (double)0.6, (double)0.6, (double)0.6);
        shape = this.combineShape(shape, north, SHAPE_CABLE_NORTH, SHAPE_BLOCK_NORTH);
        shape = this.combineShape(shape, south, SHAPE_CABLE_SOUTH, SHAPE_BLOCK_SOUTH);
        shape = this.combineShape(shape, west, SHAPE_CABLE_WEST, SHAPE_BLOCK_WEST);
        shape = this.combineShape(shape, east, SHAPE_CABLE_EAST, SHAPE_BLOCK_EAST);
        shape = this.combineShape(shape, up, SHAPE_CABLE_UP, SHAPE_BLOCK_UP);
        shape = this.combineShape(shape, down, SHAPE_CABLE_DOWN, SHAPE_BLOCK_DOWN);
        return shape;
    }

    private VoxelShape combineShape(VoxelShape shape, ConnectorType connectorType, VoxelShape cableShape, VoxelShape blockShape) {
        if (connectorType == ConnectorType.CABLE) {
            return Shapes.m_83113_((VoxelShape)shape, (VoxelShape)cableShape, (BooleanOp)BooleanOp.f_82695_);
        }
        if (connectorType == ConnectorType.BLOCK) {
            return Shapes.m_83113_((VoxelShape)shape, (VoxelShape)Shapes.m_83113_((VoxelShape)blockShape, (VoxelShape)cableShape, (BooleanOp)BooleanOp.f_82695_), (BooleanOp)BooleanOp.f_82695_);
        }
        return shape;
    }

    private Item getItem(CableColor color) {
        return switch (this.type) {
            case CableBlockType.CABLE -> {
                switch (color) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BLUE: {
                        yield CableModule.NETCABLE_BLUE.get();
                    }
                    case RED: {
                        yield CableModule.NETCABLE_RED.get();
                    }
                    case YELLOW: {
                        yield CableModule.NETCABLE_YELLOW.get();
                    }
                    case GREEN: {
                        yield CableModule.NETCABLE_GREEN.get();
                    }
                    case ROUTING: 
                }
                yield CableModule.NETCABLE_ROUTING.get();
            }
            case CableBlockType.CONNECTOR -> {
                switch (color) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BLUE: {
                        yield CableModule.CONNECTOR_BLUE.get();
                    }
                    case RED: {
                        yield CableModule.CONNECTOR_RED.get();
                    }
                    case YELLOW: {
                        yield CableModule.CONNECTOR_YELLOW.get();
                    }
                    case GREEN: {
                        yield CableModule.CONNECTOR_GREEN.get();
                    }
                    case ROUTING: 
                }
                yield CableModule.CONNECTOR_ROUTING.get();
            }
            case CableBlockType.ADVANCED_CONNECTOR -> {
                switch (color) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case BLUE: {
                        yield CableModule.ADVANCED_CONNECTOR_BLUE.get();
                    }
                    case RED: {
                        yield CableModule.ADVANCED_CONNECTOR_RED.get();
                    }
                    case YELLOW: {
                        yield CableModule.ADVANCED_CONNECTOR_YELLOW.get();
                    }
                    case GREEN: {
                        yield CableModule.ADVANCED_CONNECTOR_GREEN.get();
                    }
                    case ROUTING: 
                }
                yield CableModule.ADVANCED_CONNECTOR_ROUTING.get();
            }
            default -> Items.f_41852_;
        };
    }

    @Nonnull
    public ItemStack m_7397_(@Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, BlockState state) {
        return new ItemStack((ItemLike)this.getItem((CableColor)((Object)state.m_61143_(COLOR))));
    }

    @Nullable
    protected BlockState getMimicBlock(BlockGetter blockAccess, BlockPos pos) {
        BlockEntity te = blockAccess.m_7702_(pos);
        if (te instanceof IFacadeSupport) {
            return ((IFacadeSupport)te).getMimicBlock();
        }
        return null;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter world, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        if (this.getMimicBlock(world, pos) != null) {
            return this.getMimicBlock(world, pos).m_60651_(world, pos, context);
        }
        CableColor color = (CableColor)((Object)state.m_61143_(COLOR));
        ConnectorType north = this.getConnectorType(color, world, pos, Direction.NORTH);
        ConnectorType south = this.getConnectorType(color, world, pos, Direction.SOUTH);
        ConnectorType west = this.getConnectorType(color, world, pos, Direction.WEST);
        ConnectorType east = this.getConnectorType(color, world, pos, Direction.EAST);
        ConnectorType up = this.getConnectorType(color, world, pos, Direction.UP);
        ConnectorType down = this.getConnectorType(color, world, pos, Direction.DOWN);
        int index = this.calculateShapeIndex(north, south, west, east, up, down);
        return shapeCache[index];
    }

    public boolean isAdvancedConnector() {
        return false;
    }

    public void m_6402_(@Nonnull Level world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        BlockState blockState;
        this.originalOnBlockPlacedBy(world, pos, state, placer, stack);
        if (!world.f_46443_) {
            this.createCableSegment(world, pos, stack);
        }
        if (state != (blockState = this.calculateState((LevelAccessor)world, pos, state))) {
            world.m_46597_(pos, blockState);
        }
    }

    protected void originalOnBlockPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        super.m_6402_(world, pos, state, placer, stack);
    }

    public void createCableSegment(Level world, BlockPos pos, ItemStack stack) {
        XNetBlobData blobData = XNetBlobData.get(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        CableColor color = (CableColor)((Object)world.m_8055_(pos).m_61143_(COLOR));
        worldBlob.createCableSegment(pos, new ColorId(color.ordinal() + 1));
        blobData.save();
    }

    public void m_6810_(BlockState state, @Nonnull Level world, @Nonnull BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.m_60734_() != state.m_60734_() && !(newState.m_60734_() instanceof GenericCableBlock)) {
            this.unlinkBlock(world, pos);
        }
        super.m_6810_(state, world, pos, newState, isMoving);
    }

    public void unlinkBlock(Level world, BlockPos pos) {
        if (!world.f_46443_) {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            worldBlob.removeCableSegment(pos);
            blobData.save();
        }
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_, COLOR, NORTH, SOUTH, EAST, WEST, UP, DOWN});
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        return super.m_49635_(state, builder);
    }

    @Nonnull
    public BlockState m_7417_(BlockState state, @Nonnull Direction direction, @Nonnull BlockState neighbourState, @Nonnull LevelAccessor world, @Nonnull BlockPos current, @Nonnull BlockPos offset) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            world.m_183324_().m_183393_(new ScheduledTick((Object)Fluids.f_76193_, current, (long)Fluids.f_76193_.m_6718_((LevelReader)world), 0L));
        }
        return this.calculateState(world, current, state);
    }

    public boolean m_7357_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull PathComputationType type) {
        return super.m_7357_(state, worldIn, pos, type);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        return (BlockState)this.calculateState((LevelAccessor)world, pos, this.m_49966_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(world.m_6425_(pos).m_76152_() == Fluids.f_76193_));
    }

    @Nonnull
    public BlockState calculateState(LevelAccessor world, BlockPos pos, BlockState state) {
        CableColor color = (CableColor)((Object)state.m_61143_(COLOR));
        ConnectorType north = this.getConnectorType(color, (BlockGetter)world, pos, Direction.NORTH);
        ConnectorType south = this.getConnectorType(color, (BlockGetter)world, pos, Direction.SOUTH);
        ConnectorType west = this.getConnectorType(color, (BlockGetter)world, pos, Direction.WEST);
        ConnectorType east = this.getConnectorType(color, (BlockGetter)world, pos, Direction.EAST);
        ConnectorType up = this.getConnectorType(color, (BlockGetter)world, pos, Direction.UP);
        ConnectorType down = this.getConnectorType(color, (BlockGetter)world, pos, Direction.DOWN);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH, (Comparable)((Object)north))).m_61124_(SOUTH, (Comparable)((Object)south))).m_61124_(WEST, (Comparable)((Object)west))).m_61124_(EAST, (Comparable)((Object)east))).m_61124_(UP, (Comparable)((Object)up))).m_61124_(DOWN, (Comparable)((Object)down));
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    protected abstract ConnectorType getConnectorType(@Nonnull CableColor var1, BlockGetter var2, BlockPos var3, Direction var4);

    public TOPDriver getProbeDriver() {
        return XNetTOPDriver.DRIVER;
    }

    public static enum CableBlockType {
        CABLE,
        CONNECTOR,
        ADVANCED_CONNECTOR,
        FACADE;

    }
}

