/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.logic;

import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.OrientationTools;
import mcjty.rftoolsbase.api.xnet.keys.NetworkId;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.modules.wireless.blocks.TileEntityWirelessRouter;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class LogicTools {
    @Nullable
    public static TileEntityController getControllerForConnector(@Nonnull Level world, @Nonnull BlockPos connectorPos) {
        BlockPos controllerPos = LogicTools.getControllerPosForConnector(world, connectorPos);
        if (controllerPos == null) {
            return null;
        }
        if (!LevelTools.isLoaded((Level)world, (BlockPos)controllerPos)) {
            return null;
        }
        BlockEntity te = world.m_7702_(controllerPos);
        if (te instanceof TileEntityController) {
            return (TileEntityController)te;
        }
        return null;
    }

    @Nullable
    public static BlockPos getControllerPosForConnector(@Nonnull Level world, @Nonnull BlockPos connectorPos) {
        WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
        NetworkId networkId = worldBlob.getNetworkAt(connectorPos);
        if (networkId == null) {
            return null;
        }
        return worldBlob.getProviderPosition(networkId);
    }

    public static Set<BlockPos> consumers(@Nonnull Level world, @Nonnull NetworkId networkId) {
        WorldBlob worldBlob = XNetBlobData.get(world).getWorldBlob(world);
        return worldBlob.getConsumers(networkId);
    }

    public static void forEachConnector(@Nonnull Level world, @Nonnull BlockPos pos, Consumer<BlockPos> consumer) {
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            CableColor color;
            BlockPos connectorPos = pos.m_121945_(direction);
            BlockState state = world.m_8055_(connectorPos);
            if (!(state.m_60734_() instanceof ConnectorBlock) || (color = (CableColor)((Object)state.m_61143_(GenericCableBlock.COLOR))) == CableColor.ROUTING) continue;
            consumer.accept(connectorPos);
        }
    }

    @Nullable
    public static <T> T findRoutingConnector(@Nonnull Level world, @Nonnull BlockPos pos, Function<BlockPos, T> consumer) {
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            T result;
            CableColor color;
            BlockPos connectorPos = pos.m_121945_(direction);
            BlockState state = world.m_8055_(connectorPos);
            if (!(state.m_60734_() instanceof ConnectorBlock) || (color = (CableColor)((Object)state.m_61143_(GenericCableBlock.COLOR))) != CableColor.ROUTING || (result = consumer.apply(connectorPos)) == null) continue;
            return result;
        }
        return null;
    }

    public static void forEachRouter(@Nonnull Level world, @Nonnull BlockPos pos, Consumer<TileEntityRouter> consumer) {
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockEntity blockEntity = world.m_7702_(pos.m_121945_(direction));
            if (!(blockEntity instanceof TileEntityRouter)) continue;
            TileEntityRouter router = (TileEntityRouter)blockEntity;
            consumer.accept(router);
        }
    }

    public static void forEachWirelessRouter(@Nonnull Level world, @Nonnull BlockPos pos, Consumer<TileEntityWirelessRouter> consumer) {
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            BlockEntity blockEntity = world.m_7702_(pos.m_121945_(direction));
            if (!(blockEntity instanceof TileEntityWirelessRouter)) continue;
            TileEntityWirelessRouter router = (TileEntityWirelessRouter)blockEntity;
            consumer.accept(router);
        }
    }

    public static boolean findWirelessRouter(@Nonnull Level world, @Nonnull BlockPos pos, Predicate<TileEntityWirelessRouter> predicate) {
        for (Direction direction : OrientationTools.DIRECTION_VALUES) {
            TileEntityWirelessRouter router;
            BlockEntity blockEntity = world.m_7702_(pos.m_121945_(direction));
            if (!(blockEntity instanceof TileEntityWirelessRouter) || !predicate.test(router = (TileEntityWirelessRouter)blockEntity)) continue;
            return true;
        }
        return false;
    }

    public static void forEachRouter(@Nonnull Level world, @Nonnull NetworkId networkId, Consumer<TileEntityRouter> consumer) {
        Set<BlockPos> consumers = LogicTools.consumers(world, networkId);
        for (BlockPos pos : consumers) {
            for (Direction direction : OrientationTools.DIRECTION_VALUES) {
                BlockPos p;
                BlockEntity blockEntity;
                if (!ConnectorBlock.isConnectable((BlockGetter)world, pos, direction) || !((blockEntity = world.m_7702_(p = pos.m_121945_(direction))) instanceof TileEntityRouter)) continue;
                TileEntityRouter router = (TileEntityRouter)blockEntity;
                consumer.accept(router);
            }
        }
    }

    public static boolean[] intToBinary(int value) {
        boolean[] bits = new boolean[16];
        for (int i = 15; i >= 0; --i) {
            bits[i] = (value & 1 << i) != 0;
        }
        return bits;
    }
}

