/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.template;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.math.Axis;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.client.FakeLevel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector4f;
import org.moddingx.libx.render.ClientTickHandler;

public class TemplateRenderer {
    private final ClientLevel clientLevel = Objects.requireNonNull(FakeLevel.getInstance());
    private final StructureTemplate template;
    private final float maxX;
    private final float maxY;
    private final transient Map<BlockPos, BlockEntity> teCache = new HashMap<BlockPos, BlockEntity>();
    private final transient Set<BlockEntity> erroredTiles = Collections.newSetFromMap(new WeakHashMap());
    private final transient Set<Entity> erroredEntities = Collections.newSetFromMap(new WeakHashMap());
    private int index = 0;

    public TemplateRenderer(StructureTemplate template, float maxSize) {
        this(template, maxSize, maxSize);
    }

    public TemplateRenderer(StructureTemplate template, float maxX, float maxY) {
        this.template = template;
        this.maxX = maxX;
        this.maxY = maxY;
    }

    public void render(GuiGraphics guiGraphics, int xPos, int yPos) {
        Vec3i size = this.template.m_163801_();
        int sizeX = size.m_123341_();
        int sizeY = size.m_123342_();
        int sizeZ = size.m_123343_();
        float diagonal = (float)Math.sqrt(sizeX * sizeX + sizeZ * sizeZ);
        float scaleX = this.maxX / diagonal;
        float scaleY = this.maxY / (float)sizeY;
        float scale = -Math.min(scaleX, scaleY);
        guiGraphics.m_280168_().m_85836_();
        guiGraphics.m_280168_().m_252880_((float)xPos, (float)yPos, 100.0f);
        guiGraphics.m_280168_().m_85841_(scale, scale, scale);
        guiGraphics.m_280168_().m_252880_(-((float)sizeX) / 2.0f, -((float)sizeY) / 2.0f, 0.0f);
        Vector4f eye = new Vector4f(0.0f, 0.0f, -100.0f, 1.0f);
        Matrix4f rotMat = new Matrix4f();
        rotMat.identity();
        guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(-30.0f));
        rotMat.rotation((Quaternionfc)Axis.f_252529_.m_252977_(30.0f));
        float offX = (float)(-sizeX) / 2.0f;
        float offZ = (float)(-sizeZ) / 2.0f + 1.0f;
        float time = ClientTickHandler.ticksInGame();
        guiGraphics.m_280168_().m_252880_(-offX, 0.0f, -offZ);
        guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(time));
        rotMat.rotation((Quaternionfc)Axis.f_252436_.m_252977_(-time));
        guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(45.0f));
        rotMat.rotation((Quaternionfc)Axis.f_252436_.m_252977_(-45.0f));
        guiGraphics.m_280168_().m_252880_(offX, 0.0f, offZ);
        eye.mul((Matrix4fc)rotMat);
        this.renderElements(guiGraphics, this.template);
        guiGraphics.m_280168_().m_85849_();
        if (ClientTickHandler.ticksInGame() % 40 == 0) {
            ++this.index;
            if (this.index >= this.template.f_74482_.size()) {
                this.index = 0;
            }
        }
    }

    private void renderElements(GuiGraphics guiGraphics, StructureTemplate template) {
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280168_().m_252880_(0.0f, 0.0f, -1.0f);
        MultiBufferSource.BufferSource buffers = Minecraft.m_91087_().m_91269_().m_110104_();
        this.doWorldRenderPass(guiGraphics, template, buffers);
        this.doTileEntityRenderPass(guiGraphics, template, (MultiBufferSource)buffers);
        this.doEntityRenderPass(guiGraphics, template, (MultiBufferSource)buffers);
        buffers.m_109911_();
        guiGraphics.m_280168_().m_85849_();
    }

    private void doWorldRenderPass(GuiGraphics guiGraphics, StructureTemplate template, MultiBufferSource.BufferSource buffers) {
        StructureTemplate.Palette palette = (StructureTemplate.Palette)template.f_74482_.get(this.index);
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.m_74652_()) {
            BlockPos pos = blockInfo.f_74675_();
            BlockState bs = blockInfo.f_74676_();
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            this.renderForMultiblock(bs, pos, guiGraphics, buffers);
            guiGraphics.m_280168_().m_85849_();
        }
    }

    private void renderForMultiblock(BlockState state, BlockPos pos, GuiGraphics guiGraphics, MultiBufferSource.BufferSource buffers) {
        if (state.m_60799_() == RenderShape.MODEL) {
            BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
            BakedModel model = blockRenderer.m_110910_(state);
            for (RenderType layer : model.getRenderTypes(state, this.clientLevel.f_46441_, ModelData.EMPTY)) {
                guiGraphics.m_280168_().m_85836_();
                Lighting.m_84930_();
                Vec3 vec3 = state.m_60824_((BlockGetter)this.clientLevel, pos);
                guiGraphics.m_280168_().m_85837_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                blockRenderer.renderSingleBlock(state, guiGraphics.m_280168_(), (MultiBufferSource)buffers, 192, OverlayTexture.f_118083_, ModelData.EMPTY, layer);
                guiGraphics.m_280168_().m_85849_();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTileEntityRenderPass(GuiGraphics guiGraphics, StructureTemplate template, MultiBufferSource buffers) {
        StructureTemplate.Palette palette = (StructureTemplate.Palette)template.f_74482_.get(this.index);
        for (StructureTemplate.StructureBlockInfo blockInfo : palette.m_74652_()) {
            BlockPos pos = blockInfo.f_74675_();
            BlockState state = blockInfo.f_74676_();
            BlockEntity te = null;
            if (state.m_60734_() instanceof EntityBlock) {
                te = this.teCache.computeIfAbsent(pos.m_7949_(), p -> ((EntityBlock)state.m_60734_()).m_142194_(pos, state));
            }
            if (te == null || this.erroredTiles.contains(te)) continue;
            te.m_142339_((Level)this.clientLevel);
            te.m_155250_(state);
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_252880_((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_());
            try {
                BlockEntityRenderer renderer = Minecraft.m_91087_().m_167982_().m_112265_(te);
                if (renderer == null) continue;
                renderer.m_6922_(te, 0.0f, guiGraphics.m_280168_(), buffers, LightTexture.m_109885_((int)15, (int)15), OverlayTexture.f_118083_);
            }
            catch (Exception e) {
                this.erroredTiles.add(te);
                SkyblockBuilder.getLogger().error("An exception occurred rendering tile entity", (Throwable)e);
            }
            finally {
                guiGraphics.m_280168_().m_85849_();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doEntityRenderPass(GuiGraphics guiGraphics, StructureTemplate template, MultiBufferSource buffers) {
        for (StructureTemplate.StructureEntityInfo entityInfo : template.f_74483_) {
            Optional maybe = EntityType.m_20642_((CompoundTag)entityInfo.f_74685_, (Level)this.clientLevel);
            if (!maybe.isPresent()) continue;
            Vec3 pos = entityInfo.f_74683_;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            Entity entity = (Entity)maybe.get();
            if (this.erroredEntities.contains(entity)) continue;
            try {
                EntityRenderDispatcher entityRenderDispatcher = Minecraft.m_91087_().m_91290_();
                entityRenderDispatcher.m_114408_((Level)this.clientLevel, Minecraft.m_91087_().f_91063_.m_109153_(), entity);
                EntityRenderer renderer = entityRenderDispatcher.m_114382_(entity);
                renderer.m_7392_(entity, entity.m_146908_(), 0.0f, guiGraphics.m_280168_(), buffers, LightTexture.m_109885_((int)15, (int)15));
            }
            catch (Exception e) {
                this.erroredEntities.add(entity);
                SkyblockBuilder.getLogger().error("An exception occurred rendering entity", (Throwable)e);
            }
            finally {
                guiGraphics.m_280168_().m_85849_();
            }
        }
    }
}

