/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.template;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.TemplateUtil;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class NetherPortalTemplate {
    private final String filePath;
    private final StructureTemplate structure = new StructureTemplate();
    private final BlockPos portalOffset;

    public NetherPortalTemplate(String filePath) {
        File file = SkyPaths.TEMPLATES_DIR.resolve(filePath).toFile();
        if (!SkyPaths.NBT_OR_SNBT.test(file)) {
            throw new IllegalStateException("The file " + filePath + " is not a valid nbt or snbt file");
        }
        this.filePath = filePath;
        try {
            this.structure.m_246595_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), TemplateUtil.readTemplate(file.toPath()));
        }
        catch (CommandSyntaxException | IOException e) {
            throw new RuntimeException(e);
        }
        this.portalOffset = NetherPortalTemplate.calcPortalOffset(this.structure);
    }

    private static BlockPos calcPortalOffset(StructureTemplate template) {
        HashSet<StructureTemplate.StructureBlockInfo> netherPortals = new HashSet<StructureTemplate.StructureBlockInfo>();
        for (StructureTemplate.Palette palette : template.f_74482_) {
            for (StructureTemplate.StructureBlockInfo blockInfo2 : palette.m_74652_()) {
                if (!blockInfo2.f_74676_().m_60713_(Blocks.f_50142_)) continue;
                netherPortals.add(blockInfo2);
            }
        }
        if (netherPortals.isEmpty()) {
            throw new RuntimeException("There is no nether portal in this template");
        }
        return netherPortals.stream().sorted(Comparator.comparing(blockInfo -> blockInfo.f_74675_().m_123342_())).toList().get(0).f_74675_();
    }

    public String getFilePath() {
        return this.filePath;
    }

    public StructureTemplate getStructure() {
        return this.structure;
    }

    public BlockPos getPortalOffset() {
        return this.portalOffset.m_142393_(-1);
    }
}

