/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.template;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.ModBlockTags;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.common.TemplatesConfig;
import de.melanx.skyblockbuilder.config.common.WorldConfig;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.template.TemplateInfo;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.TemplateUtil;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.ticks.LevelTicks;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfiguredTemplate {
    private final Set<TemplatesConfig.Spawn> defaultSpawns = new HashSet<TemplatesConfig.Spawn>();
    private StructureTemplate template;
    private String name;
    private String desc;
    private TemplateInfo.Offset offset;
    private int surroundingMargin;
    private List<Block> surroundingBlocks;
    private List<SpreadConfig> spreads;

    public ConfiguredTemplate(TemplateInfo info) {
        StructureTemplate template = new StructureTemplate();
        try {
            Path file = SkyPaths.TEMPLATES_DIR.resolve(info.file());
            CompoundTag nbt = TemplateUtil.readTemplate(file);
            template.m_246595_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), nbt);
        }
        catch (CommandSyntaxException | IOException e) {
            SkyblockBuilder.getLogger().error("Template with name {} is incorrect.", (Object)info.file(), (Object)e);
        }
        this.template = template;
        this.defaultSpawns.addAll(ConfiguredTemplate.collectSpawns(TemplatesConfig.spawns.get(info.spawns())));
        this.name = info.name();
        this.desc = info.desc();
        this.offset = info.offset();
        this.surroundingMargin = info.surroundingMargin();
        List<Block> blockPalette = TemplatesConfig.surroundingBlocks.get(info.surroundingBlocks());
        this.surroundingBlocks = blockPalette != null ? List.copyOf(blockPalette) : List.of();
        List<TemplateInfo.SpreadInfo> spreadInfos = TemplatesConfig.spreads.get(info.spreads());
        ArrayList<SpreadConfig> spreadConfigs = new ArrayList<SpreadConfig>();
        if (spreadInfos != null) {
            for (TemplateInfo.SpreadInfo spreadInfo : spreadInfos) {
                spreadConfigs.add(new SpreadConfig(spreadInfo));
            }
        }
        this.spreads = List.copyOf(spreadConfigs);
    }

    private ConfiguredTemplate() {
    }

    private static Set<TemplatesConfig.Spawn> collectSpawns(Map<String, Set<BlockPos>> spawnMap) {
        HashSet<TemplatesConfig.Spawn> spawns = new HashSet<TemplatesConfig.Spawn>();
        for (Map.Entry<String, Set<BlockPos>> entry : spawnMap.entrySet()) {
            WorldUtil.Directions direction = WorldUtil.Directions.valueOf(entry.getKey().toUpperCase(Locale.ROOT));
            entry.getValue().forEach(pos -> spawns.add(new TemplatesConfig.Spawn((BlockPos)pos, direction)));
        }
        return spawns;
    }

    public void placeInWorld(ServerLevel serverLevel, Team team, StructurePlaceSettings settings, RandomSource random, int flags) {
        this.placeInWorld(serverLevel, team, team.getIsland().getCenter(), settings, random, flags);
    }

    public void placeInWorld(ServerLevel serverLevel, BlockPos pos, StructurePlaceSettings settings, RandomSource random, int flags) {
        this.placeInWorld(serverLevel, null, pos, settings, random, flags);
    }

    public void placeInWorld(ServerLevel serverLevel, @Nullable Team team, BlockPos pos, StructurePlaceSettings settings, RandomSource random, int flags) {
        LevelTicks blockTicks = serverLevel.m_183326_();
        for (SpreadConfig spread : this.spreads) {
            BlockPos offset = spread.getRandomOffset(random);
            if (spread.getOrigin() != TemplateInfo.SpreadInfo.Origin.ZERO) {
                offset = offset.m_121955_((Vec3i)TemplateInfo.SpreadInfo.Origin.originOffset(spread.getOrigin(), this.template));
            }
            BlockPos offsetPos = pos.m_121955_((Vec3i)offset);
            spread.getTemplate().m_230328_((ServerLevelAccessor)serverLevel, offsetPos, offsetPos, settings, random, flags);
            ConfiguredTemplate.clearBlockTicks(serverLevel, (LevelTicks<Block>)blockTicks, offsetPos, spread.getTemplate());
            if (team == null) continue;
            team.addSpread(spread.getFileNameWithoutExtension(), offsetPos, new BlockPos(spread.template.m_163801_()));
        }
        this.template.m_230328_((ServerLevelAccessor)serverLevel, pos, pos, settings, random, flags);
        ConfiguredTemplate.clearBlockTicks(serverLevel, (LevelTicks<Block>)blockTicks, pos, this.template);
    }

    private static void clearBlockTicks(ServerLevel level, LevelTicks<Block> blockTicks, BlockPos startPos, StructureTemplate template) {
        if (!WorldConfig.preventScheduledTicks) {
            return;
        }
        BoundingBox box = BoundingBox.m_162375_((Vec3i)startPos, (Vec3i)startPos.m_121955_(template.m_163801_()));
        BlockPos.m_121919_((BoundingBox)box).forEach(pos -> {
            if (level.m_8055_(pos).m_204336_(ModBlockTags.PREVENT_SCHEDULED_TICK)) {
                BoundingBox oneBlockBox = BoundingBox.m_162375_((Vec3i)pos, (Vec3i)pos);
                blockTicks.m_193234_(oneBlockBox);
            }
        });
    }

    public StructureTemplate getTemplate() {
        return this.template;
    }

    public Set<TemplatesConfig.Spawn> getDefaultSpawns() {
        return this.defaultSpawns;
    }

    public String getName() {
        return this.name;
    }

    public Component getNameComponent() {
        return this.name.startsWith("{") && this.name.endsWith("}") ? Component.m_237115_((String)this.name.substring(1, this.name.length() - 1)) : Component.m_237113_((String)this.name);
    }

    public Component getDescriptionComponent() {
        return this.desc.startsWith("{") && this.desc.endsWith("}") ? Component.m_237115_((String)this.desc.substring(1, this.desc.length() - 1)) : Component.m_237113_((String)this.desc);
    }

    public TemplateInfo.Offset getOffset() {
        return this.offset;
    }

    public int getSurroundingMargin() {
        return this.surroundingMargin;
    }

    public List<Block> getSurroundingBlocks() {
        return this.surroundingBlocks;
    }

    @Nonnull
    public CompoundTag write(CompoundTag nbt) {
        CompoundTag template = this.template.m_74618_(new CompoundTag());
        ListTag spawns = new ListTag();
        for (TemplatesConfig.Spawn spawn : this.defaultSpawns) {
            BlockPos pos = spawn.pos();
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("posX", pos.m_123341_());
            posTag.m_128405_("posY", pos.m_123342_());
            posTag.m_128405_("posZ", pos.m_123343_());
            posTag.m_128359_("Direction", spawn.direction().name());
            spawns.add((Object)posTag);
        }
        nbt.m_128365_("Template", (Tag)template);
        nbt.m_128365_("Spawns", (Tag)spawns);
        nbt.m_128359_("Name", this.name);
        nbt.m_128359_("Desc", this.desc);
        nbt.m_128405_("OffsetX", this.offset.x());
        nbt.m_128405_("OffsetY", this.offset.y());
        nbt.m_128405_("OffsetZ", this.offset.z());
        nbt.m_128405_("SurroundingMargin", this.surroundingMargin);
        ListTag surroundingBlocks = new ListTag();
        this.surroundingBlocks.forEach(block -> {
            StringTag tag = StringTag.m_129297_((String)Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(block), "This block doesn't exist: " + block).toString());
            surroundingBlocks.add((Object)tag);
        });
        nbt.m_128365_("SurroundingBlocks", (Tag)surroundingBlocks);
        ListTag spreads = new ListTag();
        this.spreads.forEach(spread -> {
            CompoundTag minPos = new CompoundTag();
            minPos.m_128405_("posX", spread.minOffset.m_123341_());
            minPos.m_128405_("posY", spread.minOffset.m_123342_());
            minPos.m_128405_("posZ", spread.minOffset.m_123343_());
            CompoundTag maxPos = new CompoundTag();
            maxPos.m_128405_("posX", spread.maxOffset.m_123341_());
            maxPos.m_128405_("posY", spread.maxOffset.m_123342_());
            maxPos.m_128405_("posZ", spread.maxOffset.m_123343_());
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("File", spread.fileName);
            tag.m_128359_("Origin", spread.origin.name());
            tag.m_128365_("minOffset", (Tag)minPos);
            tag.m_128365_("maxOffset", (Tag)maxPos);
            spreads.add((Object)tag);
        });
        nbt.m_128365_("Spreads", (Tag)spreads);
        return nbt;
    }

    public void read(CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        StructureTemplate template = new StructureTemplate();
        template.m_246595_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), nbt.m_128469_("Template"));
        this.template = template;
        ListTag spawns = nbt.m_128437_("Spawns", 10);
        this.defaultSpawns.clear();
        for (Tag tag : spawns) {
            CompoundTag posTag = (CompoundTag)tag;
            BlockPos pos = new BlockPos(posTag.m_128451_("posX"), posTag.m_128451_("posY"), posTag.m_128451_("posZ"));
            WorldUtil.Directions direction = WorldUtil.Directions.valueOf(posTag.m_128461_("Direction"));
            this.defaultSpawns.add(new TemplatesConfig.Spawn(pos, direction));
        }
        this.name = nbt.m_128461_("Name");
        this.desc = nbt.m_128461_("Desc");
        this.offset = new TemplateInfo.Offset(nbt.m_128451_("OffsetX"), nbt.m_128451_("OffsetY"), nbt.m_128451_("OffsetZ"));
        this.surroundingMargin = nbt.m_128451_("SurroundingMargin");
        ListTag surroundingBlocks = nbt.m_128437_("SurroundingBlocks", 8);
        HashSet<Block> blocks = new HashSet<Block>();
        for (Tag block : surroundingBlocks) {
            Block value = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.m_135820_((String)block.m_7916_()));
            blocks.add(value);
        }
        this.surroundingBlocks = List.copyOf(blocks);
        ListTag spreads = nbt.m_128437_("Spreads", 10);
        ArrayList<SpreadConfig> spreadConfigs = new ArrayList<SpreadConfig>();
        for (Tag spread : spreads) {
            String file = ((CompoundTag)spread).m_128461_("File");
            TemplateInfo.SpreadInfo.Origin origin = TemplateInfo.SpreadInfo.Origin.valueOf(((CompoundTag)spread).m_128461_("Origin"));
            CompoundTag minPos = ((CompoundTag)spread).m_128469_("minOffset");
            BlockPos minOffset = new BlockPos(minPos.m_128451_("posX"), minPos.m_128451_("posY"), minPos.m_128451_("posZ"));
            CompoundTag maxPos = ((CompoundTag)spread).m_128469_("maxOffset");
            BlockPos maxOffset = new BlockPos(maxPos.m_128451_("posX"), maxPos.m_128451_("posY"), maxPos.m_128451_("posZ"));
            spreadConfigs.add(new SpreadConfig(file, minOffset, maxOffset, origin));
        }
        this.spreads = List.copyOf(spreadConfigs);
    }

    public ConfiguredTemplate copy() {
        CompoundTag nbt = this.write(new CompoundTag());
        return ConfiguredTemplate.fromTag(nbt);
    }

    public static ConfiguredTemplate fromTag(@Nonnull CompoundTag nbt) {
        ConfiguredTemplate info = new ConfiguredTemplate();
        info.read(nbt);
        return info;
    }

    public static class SpreadConfig {
        private final String fileName;
        private final BlockPos minOffset;
        private final BlockPos maxOffset;
        private final StructureTemplate template;
        private final TemplateInfo.SpreadInfo.Origin origin;

        public SpreadConfig(TemplateInfo.SpreadInfo info) {
            this(info.file(), info.minOffset(), info.maxOffset(), info.origin());
        }

        public SpreadConfig(String fileName, BlockPos minOffset, BlockPos maxOffset, TemplateInfo.SpreadInfo.Origin origin) {
            StructureTemplate template = new StructureTemplate();
            try {
                Path file = SkyPaths.SPREADS_DIR.resolve(fileName);
                CompoundTag nbt = TemplateUtil.readTemplate(file);
                template.m_246595_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), nbt);
            }
            catch (CommandSyntaxException | IOException e) {
                SkyblockBuilder.getLogger().error("Template with file name {} is incorrect.", (Object)fileName, (Object)e);
            }
            this.fileName = fileName;
            this.minOffset = minOffset;
            this.maxOffset = maxOffset;
            this.template = template;
            this.origin = origin;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileNameWithoutExtension() {
            return this.fileName.substring(0, this.fileName.lastIndexOf("."));
        }

        public BlockPos getMinOffset() {
            return this.minOffset;
        }

        public BlockPos getMaxOffset() {
            return this.maxOffset;
        }

        public BlockPos getRandomOffset() {
            return this.getRandomOffset(RandomSource.m_216327_());
        }

        public BlockPos getRandomOffset(long seed) {
            return this.getRandomOffset(RandomSource.m_216335_((long)seed));
        }

        public BlockPos getRandomOffset(RandomSource random) {
            BlockPos offset = new BlockPos(SpreadConfig.getRandomBetween(random, this.minOffset.m_123341_(), this.maxOffset.m_123341_()), SpreadConfig.getRandomBetween(random, this.minOffset.m_123342_(), this.maxOffset.m_123342_()), SpreadConfig.getRandomBetween(random, this.minOffset.m_123343_(), this.maxOffset.m_123343_()));
            if (this.getOrigin() != TemplateInfo.SpreadInfo.Origin.ZERO) {
                offset = offset.m_121996_((Vec3i)TemplateInfo.SpreadInfo.Origin.originOffset(this.origin, this.template));
            }
            return offset;
        }

        public TemplateInfo.SpreadInfo.Origin getOrigin() {
            return this.origin;
        }

        public StructureTemplate getTemplate() {
            return this.template;
        }

        private static int getRandomBetween(RandomSource random, int i, int j) {
            if (i == j) {
                return i;
            }
            int min = Math.min(i, j);
            int max = Math.max(i, j);
            return random.m_216332_(min, max);
        }
    }
}

