/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.compat;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.util.RandomUtility;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.crafting.CraftingHelper;
import org.apache.commons.lang3.tuple.Pair;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;

public class CuriosCompat {
    public static final String MODID = "curios";
    private static final List<Pair<String, ItemStack>> STARTER_ITEMS = new ArrayList<Pair<String, ItemStack>>();

    public static void dropInventory(Player player) {
        if (player.m_9236_().f_46443_) {
            return;
        }
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> handler.getCurios().forEach((id, type) -> {
            IDynamicStackHandler stacks = type.getStacks();
            IDynamicStackHandler cosmeticStacks = type.getCosmeticStacks();
            for (int i = 0; i < type.getSlots(); ++i) {
                ItemStack stack = stacks.getStackInSlot(i);
                ItemStack stack1 = cosmeticStacks.getStackInSlot(i);
                stacks.setStackInSlot(i, ItemStack.f_41583_);
                cosmeticStacks.setStackInSlot(i, ItemStack.f_41583_);
                player.m_7197_(stack, true, false);
                player.m_7197_(stack1, true, false);
            }
        }));
    }

    public static void setStartInventory(Player player) {
        CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            Map curios = handler.getCurios();
            block0: for (Pair<String, ItemStack> entry : STARTER_ITEMS) {
                ICurioStacksHandler stacksHandler = (ICurioStacksHandler)curios.get(entry.getKey());
                if (stacksHandler == null) {
                    CuriosCompat.error(player);
                    SkyblockBuilder.getLogger().error("Curios slot identifier invalid: {}", entry.getKey());
                    continue;
                }
                IDynamicStackHandler stacks = stacksHandler.getStacks();
                for (int i = 0; i < stacksHandler.getSlots(); ++i) {
                    if (!stacks.getStackInSlot(i).m_41619_()) continue;
                    stacks.setStackInSlot(i, (ItemStack)entry.getValue());
                    continue block0;
                }
                CuriosCompat.error(player);
                SkyblockBuilder.getLogger().error("No slot available for item '{}' with identifier '{}'", entry.getValue(), entry.getKey());
            }
        });
    }

    public static void loadStarterInventory(JsonArray curiosItems) {
        STARTER_ITEMS.clear();
        for (JsonElement element : curiosItems) {
            JsonObject item = element.getAsJsonObject();
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)item, (boolean)true);
            if (!item.has("Slot")) {
                throw new IllegalStateException("Curios inventory 'Slot' identifier missing for " + stack);
            }
            String identifier = item.get("Slot").getAsString();
            STARTER_ITEMS.add((Pair<String, ItemStack>)Pair.of((Object)identifier, (Object)stack));
        }
    }

    private static void error(Player player) {
        player.m_213846_((Component)Component.m_237113_((String)"Something went wrong, look at the log for more information. If you're not the pack author, report it to them.").m_130940_(ChatFormatting.RED));
    }

    public static JsonObject serializeItem(ItemStack stack, String identifier) {
        JsonObject json = RandomUtility.serializeItem(stack);
        json.addProperty("Slot", identifier);
        return json;
    }
}

