/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.compat;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import de.melanx.skyblockbuilder.SkyblockBuilder;
import de.melanx.skyblockbuilder.config.common.CadmusConfig;
import de.melanx.skyblockbuilder.config.common.SpawnConfig;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import earth.terrarium.cadmus.api.claims.admin.flags.ComponentFlag;
import earth.terrarium.cadmus.api.claims.admin.flags.Flag;
import earth.terrarium.cadmus.common.claims.AdminClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import java.util.HashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;

public class CadmusCompat {
    public static final String MODID = "cadmus";

    public static LiteralArgumentBuilder<CommandSourceStack> spawnProtectionCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)MODID).requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)SkyblockBuilder.getInstance().modid).then(Commands.m_82127_((String)"protectSpawn").executes(source -> {
            ServerLevel level = ((CommandSourceStack)source.getSource()).m_81372_();
            SkyblockSavedData data = SkyblockSavedData.get((Level)level);
            CadmusCompat.protectSpawn(level, data.getSpawn(), true);
            ((CommandSourceStack)source.getSource()).m_288197_(() -> Component.m_237115_((String)"cadmus.skyblockbuilder.claim_spawn"), true);
            return 1;
        })));
    }

    public static void protectSpawn(ServerLevel level, Team spawnTeam) {
        CadmusCompat.protectSpawn(level, spawnTeam, false);
    }

    public static void protectSpawn(ServerLevel level, Team spawnTeam, boolean forced) {
        if (!CadmusConfig.protectSpawnChunks && !forced) {
            return;
        }
        String id = SkyblockBuilder.getInstance().modid + "_spawn";
        AdminClaimHandler.create((MinecraftServer)level.m_7654_(), (String)id, new HashMap());
        AdminClaimHandler.setFlag((MinecraftServer)level.m_7654_(), (String)id, (String)"display-name", (Flag)new ComponentFlag(CadmusConfig.displayName));
        ChunkPos pos = level.m_46865_(spawnTeam.getIsland().getCenter()).m_7697_();
        for (int xOffset = -SpawnConfig.spawnProtectionRadius; xOffset <= SpawnConfig.spawnProtectionRadius; ++xOffset) {
            for (int zOffset = -SpawnConfig.spawnProtectionRadius; zOffset <= SpawnConfig.spawnProtectionRadius; ++zOffset) {
                ClaimHandler.claim((ServerLevel)level, (String)("a:" + id), (ChunkPos)new ChunkPos(pos.f_45578_ + xOffset, pos.f_45579_ + zOffset), (ClaimType)ClaimType.CLAIMED);
            }
        }
    }
}

