/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.operator;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.template.ConfiguredTemplate;
import de.melanx.skyblockbuilder.template.TemplateLoader;
import de.melanx.skyblockbuilder.util.RandomUtility;
import de.melanx.skyblockbuilder.util.SkyPaths;
import de.melanx.skyblockbuilder.util.TemplateUtil;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.Position;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import org.moddingx.libx.command.CommandUtil;

public class GenerateCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"generate").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"template").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"template", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.TEMPLATES).executes(GenerateCommand::generateTemplate)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(GenerateCommand::generateTemplate)).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"border", (ArgumentType)BoolArgumentType.bool()).executes(GenerateCommand::generateTemplate)).then(Commands.m_82129_((String)"spreads", (ArgumentType)BoolArgumentType.bool()).executes(GenerateCommand::generateTemplate))))))).then(Commands.m_82127_((String)"spread").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"file", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.SPREADS).executes(GenerateCommand::generateSpread)).then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(GenerateCommand::generateSpread))));
    }

    private static int generateTemplate(CommandContext<CommandSourceStack> context) {
        String template = StringArgumentType.getString(context, (String)"template");
        BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_());
        boolean border = (Boolean)CommandUtil.getArgumentOrDefault(context, (String)"border", Boolean.class, (Object)false);
        boolean spreads = (Boolean)CommandUtil.getArgumentOrDefault(context, (String)"spreads", Boolean.class, (Object)false);
        try {
            pos = BlockPosArgument.m_264582_(context, (String)"pos");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        ConfiguredTemplate configuredTemplate = TemplateLoader.getConfiguredTemplate(template);
        if (configuredTemplate == null) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237115_((String)"skyblockbuilder.command.generated.fail"));
            return 0;
        }
        if (spreads) {
            configuredTemplate.placeInWorld(level, pos, TemplateLoader.STRUCTURE_PLACE_SETTINGS, level.f_46441_, 2);
        } else {
            configuredTemplate.getTemplate().m_230328_((ServerLevelAccessor)level, pos, pos, TemplateLoader.STRUCTURE_PLACE_SETTINGS, level.f_46441_, 2);
        }
        if (border) {
            SkyblockSavedData.surround(level, pos, configuredTemplate);
        }
        GenerateCommand.showLocationResult((CommandSourceStack)context.getSource(), template, pos);
        return 1;
    }

    private static int generateSpread(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CompoundTag nbt;
        String file = StringArgumentType.getString(context, (String)"file");
        BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)context.getSource()).m_81371_());
        try {
            pos = BlockPosArgument.m_264582_(context, (String)"pos");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            nbt = TemplateUtil.readTemplate(SkyPaths.SPREADS_DIR.resolve(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        StructureTemplate template = new StructureTemplate();
        template.m_246595_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), nbt);
        ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
        template.m_230328_((ServerLevelAccessor)level, pos, pos, TemplateLoader.STRUCTURE_PLACE_SETTINGS, level.f_46441_, 2);
        GenerateCommand.showLocationResult((CommandSourceStack)context.getSource(), file, pos);
        return 1;
    }

    private static void showLocationResult(CommandSourceStack source, String structureName, BlockPos generatedAt) {
        Component coords = RandomUtility.getFormattedPos(generatedAt);
        source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.generated", (Object[])new Object[]{structureName, coords}), true);
    }
}

