/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.skyblockbuilder.commands.helper;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.melanx.skyblockbuilder.commands.Suggestions;
import de.melanx.skyblockbuilder.data.SkyblockSavedData;
import de.melanx.skyblockbuilder.data.Team;
import de.melanx.skyblockbuilder.util.WorldUtil;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.util.StringUtil;
import net.minecraft.world.level.Level;

public class ListCommand {
    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"list").executes(context -> ListCommand.listTeams((CommandSourceStack)context.getSource()))).then(Commands.m_82129_((String)"team", (ArgumentType)StringArgumentType.string()).suggests(Suggestions.ALL_TEAMS).executes(context -> ListCommand.listPlayers((CommandSourceStack)context.getSource(), StringArgumentType.getString((CommandContext)context, (String)"team"))));
    }

    private static int listTeams(CommandSourceStack source) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        List<Team> teams = data.getTeams().stream().sorted(Comparator.comparing(Team::getName)).filter(team -> !team.getName().equalsIgnoreCase("spawn")).toList();
        MutableComponent info = Component.m_237110_((String)"skyblockbuilder.command.info.teams", (Object[])new Object[]{teams.size(), teams.stream().filter(Team::isEmpty).count()});
        info.m_130940_(ChatFormatting.GOLD);
        source.m_288197_(() -> info, false);
        for (Team team2 : teams) {
            if (team2.isSpawn()) continue;
            MutableComponent list = Component.m_237113_((String)("- " + team2.getName()));
            if (team2.isEmpty()) {
                list.m_130946_(" (");
                list.m_7220_((Component)Component.m_237115_((String)"skyblockbuilder.command.argument.empty"));
                list.m_130946_(")");
                list.m_130940_(ChatFormatting.RED);
            } else {
                list.m_130940_(ChatFormatting.GREEN);
            }
            source.m_288197_(() -> list, false);
        }
        return 1;
    }

    private static int listPlayers(CommandSourceStack source, String teamName) throws CommandSyntaxException {
        WorldUtil.checkSkyblock(source);
        ServerLevel level = source.m_81372_();
        SkyblockSavedData data = SkyblockSavedData.get((Level)level);
        Team team = data.getTeam(teamName);
        if (team == null) {
            source.m_288197_(() -> Component.m_237115_((String)"skyblockbuilder.command.error.team_not_exist").m_130940_(ChatFormatting.RED), false);
            return 0;
        }
        GameProfileCache profileCache = source.m_81377_().m_129927_();
        source.m_288197_(() -> Component.m_237110_((String)"skyblockbuilder.command.info.team_detailed", (Object[])new Object[]{team.getName(), team.getPlayers().size()}).m_130940_(ChatFormatting.GOLD), false);
        team.getPlayers().forEach(id -> {
            String name;
            Optional profile = profileCache.m_11002_(id);
            if (profile.isPresent() && !StringUtil.m_14408_((String)(name = ((GameProfile)profile.get()).getName()))) {
                source.m_288197_(() -> Component.m_237113_((String)("- " + name)), false);
            }
        });
        return 1;
    }
}

