/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.network.packet;

import edivad.solargeneration.blockentity.SolarPanelBlockEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public record UpdateSolarPanel(BlockPos pos, int currentEnergy, int currentProduction) {
    public static UpdateSolarPanel decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int currentEnergy = buf.readInt();
        int currentProduction = buf.readInt();
        return new UpdateSolarPanel(pos, currentEnergy, currentProduction);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.currentEnergy);
        buf.writeInt(this.currentProduction);
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        UpdateSolarPanelClient.handle(this, ctx);
        ctx.get().setPacketHandled(true);
    }

    public static class UpdateSolarPanelClient {
        public static void handle(UpdateSolarPanel packet, Supplier<NetworkEvent.Context> ctx) {
            BlockEntity blockEntity;
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            if (level != null && level.m_46749_(packet.pos) && (blockEntity = level.m_7702_(packet.pos)) instanceof SolarPanelBlockEntity) {
                SolarPanelBlockEntity solar = (SolarPanelBlockEntity)blockEntity;
                solar.energyClient = packet.currentEnergy;
                solar.energyProductionClient = packet.currentProduction;
            }
        }
    }
}

