/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.datagen;

import edivad.edivadlib.tools.TranslationsAdvancement;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Translations;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.common.data.ForgeAdvancementProvider;
import net.minecraftforge.registries.RegistryObject;

public class AdvancementProvider
extends ForgeAdvancementProvider {
    public AdvancementProvider(PackOutput packOutput, CompletableFuture<HolderLookup.Provider> registries, ExistingFileHelper existingFileHelper) {
        super(packOutput, registries, existingFileHelper, List.of(new Advancements()));
    }

    private static class Advancements
    implements ForgeAdvancementProvider.AdvancementGenerator {
        private Advancements() {
        }

        private static FrameType getFrameType(SolarPanelLevel level) {
            return switch (level) {
                default -> throw new IncompatibleClassChangeError();
                case SolarPanelLevel.LEADSTONE, SolarPanelLevel.HARDENED, SolarPanelLevel.REDSTONE -> FrameType.TASK;
                case SolarPanelLevel.SIGNALUM, SolarPanelLevel.RESONANT -> FrameType.GOAL;
                case SolarPanelLevel.ADVANCED, SolarPanelLevel.ULTIMATE -> FrameType.CHALLENGE;
            };
        }

        public void generate(HolderLookup.Provider registries, Consumer<Advancement> consumer, ExistingFileHelper existingFileHelper) {
            TranslationsAdvancement translations;
            RegistryObject<Item> item;
            Advancement ROOT;
            Advancement parent = ROOT = Advancement.Builder.m_138353_().m_138371_((ItemLike)Registration.PHOTOVOLTAIC_CELL.get(), (Component)Translations.ADVANCEMENTS_ROOT.translateTitle(), (Component)Translations.ADVANCEMENTS_ROOT.translateDescription(), new ResourceLocation("solargeneration", "textures/gui/advancements.png"), FrameType.TASK, true, true, false).m_138386_("inv_changed", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)Registration.PHOTOVOLTAIC_CELL.get()})).save(consumer, new ResourceLocation("solargeneration", "root"), existingFileHelper);
            for (SolarPanelLevel level : SolarPanelLevel.values()) {
                item = Registration.SOLAR_PANEL_ITEM.get((Object)level);
                translations = Translations.SOLAR_PANEL_ADVANCEMENTS.get((Object)level);
                parent = this.generateAdvancements(consumer, existingFileHelper, level, parent, item, translations, level.getSolarPanelName());
            }
            parent = ROOT;
            for (SolarPanelLevel level : SolarPanelLevel.values()) {
                item = Registration.HELMET.get((Object)level);
                translations = Translations.HELMET_ADVANCEMENTS.get((Object)level);
                parent = this.generateAdvancements(consumer, existingFileHelper, level, parent, item, translations, level.getSolarHelmetName());
            }
        }

        private Advancement generateAdvancements(Consumer<Advancement> consumer, ExistingFileHelper existingFileHelper, SolarPanelLevel level, Advancement parent, RegistryObject<Item> item, TranslationsAdvancement itemTranslations, String name) {
            return Advancement.Builder.m_138353_().m_138371_((ItemLike)item.get(), (Component)itemTranslations.translateTitle(), (Component)itemTranslations.translateDescription(), null, Advancements.getFrameType(level), true, true, false).m_138386_("inv_changed", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)item.get()})).m_138398_(parent).save(consumer, new ResourceLocation("solargeneration", name), existingFileHelper);
        }
    }
}

