/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.blockentity;

import edivad.solargeneration.menu.SolarPanelMenu;
import edivad.solargeneration.network.PacketHandler;
import edivad.solargeneration.network.packet.UpdateSolarPanel;
import edivad.solargeneration.setup.Registration;
import edivad.solargeneration.tools.ProductionSolarPanel;
import edivad.solargeneration.tools.SolarPanelBattery;
import edivad.solargeneration.tools.SolarPanelLevel;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.network.PacketDistributor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SolarPanelBlockEntity
extends BlockEntity
implements MenuProvider {
    private final int energyGeneration;
    private final int maxTransfer;
    private final SolarPanelBattery solarPanelBattery;
    private final LazyOptional<IEnergyStorage> energy;
    private final SolarPanelLevel levelSolarPanel;
    public int energyClient;
    public int energyProductionClient;

    public SolarPanelBlockEntity(SolarPanelLevel levelSolarPanel, BlockPos pos, BlockState state) {
        super((BlockEntityType)Registration.SOLAR_PANEL_TILE.get((Object)levelSolarPanel).get(), pos, state);
        this.levelSolarPanel = levelSolarPanel;
        this.energyGeneration = levelSolarPanel.getEnergyGeneration();
        this.maxTransfer = levelSolarPanel.getMaxTransfer();
        int capacity = levelSolarPanel.getCapacity();
        this.solarPanelBattery = new SolarPanelBattery(this.maxTransfer, capacity);
        this.energy = LazyOptional.of(() -> this.solarPanelBattery);
        this.energyProductionClient = -1;
        this.energyClient = -1;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState blockState, SolarPanelBlockEntity solarPanel) {
        int energyProducedBySun = solarPanel.currentAmountEnergyProduced();
        solarPanel.solarPanelBattery.generatePower(energyProducedBySun);
        solarPanel.sendEnergy();
        int energyStored = solarPanel.solarPanelBattery.getEnergyStored();
        if (solarPanel.energyClient != energyStored || solarPanel.energyProductionClient != energyProducedBySun) {
            int energyProduced = solarPanel.solarPanelBattery.isFullEnergy() ? 0 : energyProducedBySun;
            solarPanel.m_6596_();
            UpdateSolarPanel message = new UpdateSolarPanel(blockPos, energyStored, energyProduced);
            PacketHandler.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> level.m_46745_(blockPos)), (Object)message);
        }
    }

    private int currentAmountEnergyProduced() {
        return (int)((float)this.energyGeneration * ProductionSolarPanel.computeSunIntensity(this.f_58857_, this.f_58858_, this.levelSolarPanel));
    }

    private void sendEnergy() {
        AtomicInteger capacity = new AtomicInteger(this.solarPanelBattery.getEnergyStored());
        for (int i = 0; i < Direction.values().length && capacity.get() > 0; ++i) {
            BlockEntity blockEntity;
            Direction facing = Direction.values()[i];
            if (facing.equals((Object)Direction.UP) || (blockEntity = this.f_58857_.m_7702_(this.f_58858_.m_121945_(facing))) == null) continue;
            blockEntity.getCapability(ForgeCapabilities.ENERGY, facing.m_122424_()).ifPresent(handler -> {
                if (handler.canReceive()) {
                    int received = handler.receiveEnergy(Math.min(capacity.get(), this.maxTransfer), false);
                    capacity.addAndGet(-received);
                    this.solarPanelBattery.consumePower(received);
                    this.m_6596_();
                }
            });
        }
    }

    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, Direction side) {
        if (cap == ForgeCapabilities.ENERGY && side != Direction.UP) {
            return this.energy.cast();
        }
        return super.getCapability(cap, side);
    }

    public SolarPanelLevel getLevelSolarPanel() {
        return this.levelSolarPanel;
    }

    public void m_7651_() {
        super.m_7651_();
        this.energy.invalidate();
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        Tag energyTag = tag.m_128423_("energy");
        if (energyTag != null) {
            this.solarPanelBattery.deserializeNBT(energyTag);
        }
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("energy", this.solarPanelBattery.serializeNBT());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new SolarPanelMenu(id, this, this.levelSolarPanel);
    }

    public Component m_5446_() {
        return Component.m_237115_((String)this.m_58900_().m_60734_().m_7705_());
    }
}

