/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.container;

import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.block.tile.IScreenInfoProvider;
import com.hrznstudio.titanium.client.screen.asset.DefaultAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.client.screen.asset.IHasAssetProvider;
import com.hrznstudio.titanium.container.IObjectContainer;
import com.hrznstudio.titanium.container.addon.IContainerAddonProvider;
import com.hrznstudio.titanium.container.addon.UpdatableSlotItemHandler;
import com.hrznstudio.titanium.container.impl.BasicInventoryContainer;
import com.hrznstudio.titanium.network.locator.ILocatable;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.EmptyLocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.InventoryStackLocatorInstance;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.RegistryObject;

public class BasicAddonContainer
extends BasicInventoryContainer
implements IObjectContainer,
ILocatable {
    public static RegistryObject<MenuType<?>> TYPE;
    private final ContainerLevelAccess worldPosCallable;
    private final Object provider;
    private final LocatorInstance locatorInstance;

    public BasicAddonContainer(Object provider, LocatorInstance locatorInstance, ContainerLevelAccess worldPosCallable, Inventory playerInventory, int containerId) {
        this(provider, locatorInstance, (MenuType<BasicAddonContainer>)((MenuType)TYPE.get()), worldPosCallable, playerInventory, containerId);
    }

    public BasicAddonContainer(Object provider, LocatorInstance locatorInstance, MenuType<BasicAddonContainer> containerType, ContainerLevelAccess worldPosCallable, Inventory playerInventory, int containerId) {
        super(containerType, playerInventory, containerId, BasicAddonContainer.findAssetProvider(provider));
        this.worldPosCallable = worldPosCallable;
        this.provider = provider;
        this.locatorInstance = locatorInstance;
        if (this.provider instanceof IContainerAddonProvider) {
            ((IContainerAddonProvider)this.provider).getContainerAddons().stream().map(IFactory::create).forEach(containAddon -> {
                containAddon.getSlots().forEach(x$0 -> this.m_38897_((Slot)x$0));
                containAddon.getIntReferenceHolders().forEach(x$0 -> this.m_38895_((DataSlot)x$0));
                containAddon.getIntArrayReferenceHolders().forEach(x$0 -> this.m_38884_((ContainerData)x$0));
            });
        }
        this.initInventory();
    }

    private static IAssetProvider findAssetProvider(Object provider) {
        if (provider instanceof IHasAssetProvider) {
            return ((IHasAssetProvider)provider).getAssetProvider();
        }
        return DefaultAssetProvider.DEFAULT_PROVIDER;
    }

    @Override
    public boolean m_6875_(Player playerIn) {
        return (Boolean)this.worldPosCallable.m_39299_((world, blockPos) -> playerIn.m_20275_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.5, (double)blockPos.m_123343_() + 0.5) <= 64.0, (Object)true) == false || !(this.provider instanceof IContainerAddonProvider) || ((IContainerAddonProvider)this.provider).canInteract();
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        if (this.locatorInstance instanceof InventoryStackLocatorInstance) {
            int slot = ((InventoryStackLocatorInstance)this.locatorInstance).getInventorySlot();
            slot = slot < 9 ? (slot += 27) : (slot -= 9);
            if (slot == slotId) {
                this.m_38946_();
            }
        }
        super.m_150399_(slotId, dragType, clickTypeIn, player);
    }

    public static BasicAddonContainer create(int id, Inventory inventory, FriendlyByteBuf packetBuffer) {
        LocatorInstance instance = LocatorFactory.readPacketBuffer(packetBuffer);
        if (instance != null) {
            Player playerEntity = inventory.f_35978_;
            Level world = playerEntity.m_20193_();
            BasicAddonContainer container = instance.locale(playerEntity).map(located -> new BasicAddonContainer(located, instance, instance.getWorldPosCallable(world), inventory, id)).orElse(null);
            if (container != null) {
                return container;
            }
        }
        Titanium.LOGGER.error("Failed to find locate instance to create Container for");
        return new BasicAddonContainer(new Object(), new EmptyLocatorInstance(), ContainerLevelAccess.f_39287_, inventory, id);
    }

    public Object getProvider() {
        return this.provider;
    }

    @Override
    public Object getObject() {
        return this.getProvider();
    }

    @Override
    public LocatorInstance getLocatorInstance() {
        return this.locatorInstance;
    }

    public int getTitleColorFromProvider() {
        Object object = this.provider;
        if (object instanceof IScreenInfoProvider) {
            IScreenInfoProvider provider = (IScreenInfoProvider)object;
            return provider.getTitleColor();
        }
        return 0xFFFFFF;
    }

    public float getTitleXPos(float titleWidth, float screenWidth, float screenHeight, float guiWidth, float guiHeight) {
        Object object = this.provider;
        if (object instanceof IScreenInfoProvider) {
            IScreenInfoProvider provider = (IScreenInfoProvider)object;
            return provider.getTitleXPos(titleWidth, screenWidth, screenHeight, guiWidth, guiHeight);
        }
        return (screenWidth - guiWidth) / 2.0f + guiWidth / 2.0f - titleWidth / 2.0f;
    }

    public float getTitleYPos(float titleWidth, float screenWidth, float screenHeight, float guiWidth, float guiHeight) {
        Object object = this.provider;
        if (object instanceof IScreenInfoProvider) {
            IScreenInfoProvider provider = (IScreenInfoProvider)object;
            return provider.getTitleYPos(titleWidth, screenWidth, screenHeight, guiWidth, guiHeight);
        }
        return (screenHeight - guiHeight) / 2.0f + 6.0f;
    }

    public void update() {
        this.f_38839_.stream().filter(slot -> slot instanceof UpdatableSlotItemHandler).forEach(slot -> ((UpdatableSlotItemHandler)((Object)slot)).update());
    }
}

