/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.AlmostUnified;
import com.almostreliable.unified.ReplacementData;
import com.almostreliable.unified.config.UnifyConfig;
import com.almostreliable.unified.utils.ReplacementMap;
import com.almostreliable.unified.utils.TagMap;
import com.almostreliable.unified.utils.UnifyTag;
import com.almostreliable.unified.utils.Utils;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public final class TagReloadHandler {
    private static final Object LOCK = new Object();
    private static Map<ResourceLocation, Collection<Holder<Item>>> RAW_ITEM_TAGS;
    private static Map<ResourceLocation, Collection<Holder<Block>>> RAW_BLOCK_TAGS;

    private TagReloadHandler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initItemTags(Map<ResourceLocation, Collection<Holder<Item>>> rawItemTags) {
        Object object = LOCK;
        synchronized (object) {
            RAW_ITEM_TAGS = rawItemTags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initBlockTags(Map<ResourceLocation, Collection<Holder<Block>>> rawBlockTags) {
        Object object = LOCK;
        synchronized (object) {
            RAW_BLOCK_TAGS = rawBlockTags;
        }
    }

    public static void run() {
        if (RAW_ITEM_TAGS == null || RAW_BLOCK_TAGS == null) {
            return;
        }
        AlmostUnified.onTagLoaderReload(RAW_ITEM_TAGS);
        RAW_ITEM_TAGS = null;
        RAW_BLOCK_TAGS = null;
    }

    public static void applyCustomTags(UnifyConfig unifyConfig) {
        Preconditions.checkNotNull(RAW_ITEM_TAGS, (Object)"Item tags were not loaded correctly");
        HashMultimap changedItemTags = HashMultimap.create();
        for (Map.Entry<ResourceLocation, Set<ResourceLocation>> entry : unifyConfig.getCustomTags().entrySet()) {
            ResourceLocation tag2 = entry.getKey();
            Set<ResourceLocation> itemIds = entry.getValue();
            for (ResourceLocation itemId : itemIds) {
                if (!BuiltInRegistries.f_257033_.m_7804_(itemId)) {
                    AlmostUnified.LOG.warn("[CustomTags] Custom tag '{}' contains invalid item '{}'", (Object)tag2, (Object)itemId);
                    continue;
                }
                ResourceKey itemKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)itemId);
                Holder itemHolder = BuiltInRegistries.f_257033_.m_203636_(itemKey).orElse(null);
                if (itemHolder == null) continue;
                ImmutableSet.Builder newHolders = ImmutableSet.builder();
                Collection<Holder<Item>> currentHolders = RAW_ITEM_TAGS.get(tag2);
                if (currentHolders != null) {
                    if (currentHolders.contains(itemHolder)) {
                        AlmostUnified.LOG.warn("[CustomTags] Custom tag '{}' already contains item '{}'", (Object)tag2, (Object)itemId);
                        continue;
                    }
                    newHolders.addAll(currentHolders);
                }
                newHolders.add((Object)itemHolder);
                RAW_ITEM_TAGS.put(tag2, (Collection<Holder<Item>>)newHolders.build());
                changedItemTags.put((Object)tag2, (Object)itemId);
            }
        }
        if (!changedItemTags.isEmpty()) {
            changedItemTags.asMap().forEach((tag, items) -> AlmostUnified.LOG.info("[CustomTags] Modified tag '#{}', added {}", tag, items));
        }
    }

    public static boolean applyInheritance(UnifyConfig unifyConfig, ReplacementData replacementData) {
        Preconditions.checkNotNull(RAW_ITEM_TAGS, (Object)"Item tags were not loaded correctly");
        Preconditions.checkNotNull(RAW_BLOCK_TAGS, (Object)"Block tags were not loaded correctly");
        HashMultimap changedItemTags = HashMultimap.create();
        HashMultimap changedBlockTags = HashMultimap.create();
        Set<TagRelation> relations = TagReloadHandler.resolveRelations(replacementData.filteredTagMap(), replacementData.replacementMap());
        if (relations.isEmpty()) {
            return false;
        }
        TagMap<Block> blockTagMap = TagMap.createFromBlockTags(RAW_BLOCK_TAGS);
        TagMap<Item> globalTagMap = replacementData.globalTagMap();
        for (TagRelation relation : relations) {
            ResourceLocation dominant2 = relation.dominant;
            Holder<Item> dominantItemHolder = TagReloadHandler.findDominantItemHolder(relation);
            Holder<Block> dominantBlockHolder = TagReloadHandler.findDominantBlockHolder(blockTagMap, dominant2);
            Set<UnifyTag<Item>> dominantItemTags = globalTagMap.getTagsByEntry(dominant2);
            for (ResourceLocation item : relation.items) {
                Set<ResourceLocation> changed;
                if (dominantItemHolder != null) {
                    changed = TagReloadHandler.applyItemTags(unifyConfig, globalTagMap, dominantItemHolder, dominantItemTags, item);
                    changedItemTags.putAll((Object)dominant2, changed);
                }
                if (dominantBlockHolder == null) continue;
                changed = TagReloadHandler.applyBlockTags(unifyConfig, blockTagMap, dominantBlockHolder, dominantItemTags, item);
                changedBlockTags.putAll((Object)dominant2, changed);
            }
        }
        if (!changedBlockTags.isEmpty()) {
            changedBlockTags.asMap().forEach((dominant, tags) -> AlmostUnified.LOG.info("[TagInheritance] Added '{}' to block tags {}", dominant, tags));
        }
        if (!changedItemTags.isEmpty()) {
            changedItemTags.asMap().forEach((dominant, tags) -> AlmostUnified.LOG.info("[TagInheritance] Added '{}' to item tags {}", dominant, tags));
            return true;
        }
        return false;
    }

    private static Set<TagRelation> resolveRelations(TagMap<Item> filteredTagMap, ReplacementMap repMap) {
        HashSet<TagRelation> relations = new HashSet<TagRelation>();
        for (UnifyTag<Item> unifyTag : filteredTagMap.getTags()) {
            Set<ResourceLocation> items;
            ResourceLocation dominant;
            Set<ResourceLocation> itemsByTag = filteredTagMap.getEntriesByTag(unifyTag);
            if (Utils.allSameNamespace(itemsByTag) || (dominant = repMap.getPreferredItemForTag(unifyTag, $ -> true)) == null || !BuiltInRegistries.f_257033_.m_7804_(dominant) || (items = TagReloadHandler.getValidatedItems(itemsByTag, dominant)).isEmpty()) continue;
            relations.add(new TagRelation(unifyTag.location(), dominant, items));
        }
        return relations;
    }

    private static Set<ResourceLocation> getValidatedItems(Set<ResourceLocation> itemIds, ResourceLocation dominant) {
        HashSet<ResourceLocation> result = new HashSet<ResourceLocation>(itemIds.size());
        for (ResourceLocation id : itemIds) {
            if (id.equals((Object)dominant) || !BuiltInRegistries.f_257033_.m_7804_(id)) continue;
            result.add(id);
        }
        return result;
    }

    @Nullable
    private static Holder<Item> findDominantItemHolder(TagRelation relation) {
        Collection tagHolders = RAW_ITEM_TAGS.get(relation.tag);
        if (tagHolders == null) {
            return null;
        }
        return TagReloadHandler.findDominantHolder(tagHolders, relation.dominant);
    }

    @Nullable
    private static Holder<Block> findDominantBlockHolder(TagMap<Block> tagMap, ResourceLocation dominant) {
        Set<UnifyTag<Block>> blockTags = tagMap.getTagsByEntry(dominant);
        if (blockTags.isEmpty()) {
            return null;
        }
        Collection tagHolders = RAW_BLOCK_TAGS.get(blockTags.iterator().next().location());
        if (tagHolders == null) {
            return null;
        }
        return TagReloadHandler.findDominantHolder(tagHolders, dominant);
    }

    @Nullable
    private static <T> Holder<T> findDominantHolder(Collection<Holder<T>> holders, ResourceLocation dominant) {
        for (Holder<T> tagHolder : holders) {
            Optional holderKey = tagHolder.m_203543_();
            if (!holderKey.isPresent() || !((ResourceKey)holderKey.get()).m_135782_().equals((Object)dominant)) continue;
            return tagHolder;
        }
        return null;
    }

    private static Set<ResourceLocation> applyItemTags(UnifyConfig unifyConfig, TagMap<Item> globalTagMap, Holder<Item> dominantItemHolder, Set<UnifyTag<Item>> dominantItemTags, ResourceLocation item) {
        Set<UnifyTag<Item>> itemTags = globalTagMap.getTagsByEntry(item);
        HashSet<ResourceLocation> changed = new HashSet<ResourceLocation>();
        for (UnifyTag<Item> itemTag : itemTags) {
            if (!unifyConfig.shouldInheritItemTag(itemTag, dominantItemTags) || !TagReloadHandler.tryUpdatingRawTags(dominantItemHolder, itemTag, RAW_ITEM_TAGS)) continue;
            changed.add(itemTag.location());
        }
        return changed;
    }

    private static Set<ResourceLocation> applyBlockTags(UnifyConfig unifyConfig, TagMap<Block> blockTagMap, Holder<Block> dominantBlockHolder, Set<UnifyTag<Item>> dominantItemTags, ResourceLocation item) {
        Set<UnifyTag<Block>> blockTags = blockTagMap.getTagsByEntry(item);
        HashSet<ResourceLocation> changed = new HashSet<ResourceLocation>();
        for (UnifyTag<Block> blockTag : blockTags) {
            if (!unifyConfig.shouldInheritBlockTag(blockTag, dominantItemTags) || !TagReloadHandler.tryUpdatingRawTags(dominantBlockHolder, blockTag, RAW_BLOCK_TAGS)) continue;
            changed.add(blockTag.location());
        }
        return changed;
    }

    private static <T> boolean tryUpdatingRawTags(Holder<T> dominantHolder, UnifyTag<T> tag, Map<ResourceLocation, Collection<Holder<T>>> rawTags) {
        Collection<Holder<T>> tagHolders = rawTags.get(tag.location());
        if (tagHolders == null) {
            return false;
        }
        if (tagHolders.contains(dominantHolder)) {
            return false;
        }
        ImmutableSet.Builder newHolders = ImmutableSet.builder();
        newHolders.addAll(tagHolders);
        newHolders.add(dominantHolder);
        rawTags.put(tag.location(), (Collection<Holder<T>>)newHolders.build());
        return true;
    }

    private record TagRelation(ResourceLocation tag, ResourceLocation dominant, Set<ResourceLocation> items) {
    }
}

