/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.api.recipe.RecipeContext;
import com.almostreliable.unified.api.recipe.RecipeUnifier;
import com.almostreliable.unified.api.recipe.RecipeUnifierBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nullable;

public class ImmersiveEngineeringRecipeUnifier
implements RecipeUnifier {
    private static final String BASE_INGREDIENT = "base_ingredient";

    @Override
    public void collectUnifier(RecipeUnifierBuilder builder) {
        List.of("input0", "input1", "input", "additives", "catalyst").forEach(key -> builder.put((String)key, this::createIngredientReplacement));
        List.of("result", "results", "slag").forEach(key -> builder.put((String)key, (json, ctx) -> ctx.createResultReplacement((JsonElement)json, true, "item", BASE_INGREDIENT)));
        builder.forEachObject("secondaries", (json, ctx) -> {
            JsonElement replacement = ctx.createResultReplacement(json.get("output"), true, new String[0]);
            if (replacement instanceof JsonObject) {
                JsonObject output = (JsonObject)replacement;
                json.add("output", (JsonElement)output);
                return json;
            }
            return null;
        });
    }

    @Nullable
    private JsonElement createIngredientReplacement(@Nullable JsonElement element, RecipeContext ctx) {
        JsonObject json;
        if (element instanceof JsonObject && (json = (JsonObject)element).has(BASE_INGREDIENT)) {
            return ctx.createIngredientReplacement(json.get(BASE_INGREDIENT));
        }
        return ctx.createIngredientReplacement(element);
    }
}

