/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.api;

import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;

public interface AlmostUnifiedLookup {
    public static final AlmostUnifiedLookup INSTANCE = ServiceLoader.load(AlmostUnifiedLookup.class).findFirst().orElseGet(Empty::new);

    public boolean isLoaded();

    @Nullable
    public Item getReplacementForItem(ItemLike var1);

    @Nullable
    public Item getPreferredItemForTag(TagKey<Item> var1);

    @Nullable
    public TagKey<Item> getPreferredTagForItem(ItemLike var1);

    public Set<Item> getPotentialItems(TagKey<Item> var1);

    public Set<TagKey<Item>> getConfiguredTags();

    public static class Empty
    implements AlmostUnifiedLookup {
        @Override
        public boolean isLoaded() {
            return false;
        }

        @Override
        @Nullable
        public Item getReplacementForItem(ItemLike itemLike) {
            return null;
        }

        @Override
        @Nullable
        public Item getPreferredItemForTag(TagKey<Item> tag) {
            return null;
        }

        @Override
        @Nullable
        public TagKey<Item> getPreferredTagForItem(ItemLike itemLike) {
            return null;
        }

        @Override
        public Set<Item> getPotentialItems(TagKey<Item> tag) {
            return Set.of();
        }

        @Override
        public Set<TagKey<Item>> getConfiguredTags() {
            return Set.of();
        }
    }
}

