/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.kubeio.kube.event;

import com.almostreliable.kubeio.enderio.CustomConduitEntry;
import com.almostreliable.kubeio.enderio.CustomEnergyConduitType;
import com.enderio.EnderIO;
import com.enderio.api.conduit.ConduitItemFactory;
import com.enderio.conduits.common.init.EIOConduitTypes;
import com.google.common.base.Preconditions;
import dev.latvian.mods.kubejs.event.EventJS;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public class ConduitRegistryEvent
extends EventJS {
    @HideFromJS
    public static final Set<CustomConduitEntry> CONDUITS = new HashSet<CustomConduitEntry>();

    public void registerEnergyConduit(String id, String name, int transferRate) {
        Preconditions.checkArgument((!id.contains(":") ? 1 : 0) != 0, (Object)"id must not contain a colon (:)");
        Preconditions.checkArgument((!id.contains(" ") ? 1 : 0) != 0, (Object)"id must not contain a space");
        Preconditions.checkArgument((boolean)CONDUITS.stream().noneMatch(conduit -> conduit.id().equals(id)), (Object)"id must be unique");
        RegistryObject type = EIOConduitTypes.CONDUIT_TYPES.register(id, () -> new CustomEnergyConduitType(EnderIO.loc((String)id), transferRate));
        Item item = ConduitItemFactory.build((Supplier)type, (Item.Properties)new Item.Properties());
        ForgeRegistries.ITEMS.register(EnderIO.loc((String)id), (Object)item);
        CONDUITS.add(new CustomConduitEntry(id, name, item));
    }
}

