/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.mixins;

import com.google.common.base.Strings;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.logging.LogUtils;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StateDefinition.Builder.class})
public abstract class SPC_StateStateDefinitionBuilder<O, S extends StateHolder<O, S>> {
    private static final Cache<String, Boolean> ERROR_CACHE = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Logger LOGGER = LogUtils.getLogger();
    @Shadow
    @Final
    private O f_61095_;
    @Shadow
    @Final
    private Map<String, Property<?>> f_61096_;

    @Shadow
    protected abstract <T extends Comparable<T>> void m_61099_(Property<T> var1);

    @Inject(method={"add"}, at={@At(value="HEAD")}, cancellable=true)
    private void shetiphiancore_add_inject(Property<?>[] properties, CallbackInfoReturnable<StateDefinition.Builder<O, S>> cir) {
        for (Property<?> property : properties) {
            String name = property.m_61708_();
            if (!property.equals(this.f_61096_.get(name))) {
                this.m_61099_(property);
                this.f_61096_.put(name, property);
                continue;
            }
            String className = this.f_61095_.getClass().getCanonicalName();
            if (Strings.isNullOrEmpty((String)className)) {
                className = this.f_61095_.getClass().getName();
            }
            if (Strings.isNullOrEmpty((String)className) || ERROR_CACHE.getIfPresent((Object)className) != null) continue;
            ERROR_CACHE.put((Object)className, (Object)true);
            LOGGER.info("Skipping property '" + name + "' as '" + className + "' already contains this exact property. It was likely added to the parent by another mod, and will cause a crash if added again. -ShetiPhian");
        }
        cir.setReturnValue((Object)((StateDefinition.Builder)this));
        cir.cancel();
    }
}

