/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.network;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import shetiphian.core.common.Function;
import shetiphian.core.common.inventory.ISidedWrapper;
import shetiphian.core.common.network.PacketBase;

public class PacketSidedWrapper
extends PacketBase {
    private final BlockPos posTile;
    private final byte[] indexes;

    public PacketSidedWrapper(BlockPos posTile, byte[] indexes) {
        this.posTile = posTile;
        this.indexes = indexes;
    }

    public static void writeData(PacketSidedWrapper packet, FriendlyByteBuf buffer) {
        buffer.m_130064_(packet.posTile);
        buffer.m_130087_(packet.indexes);
    }

    public static PacketSidedWrapper readData(FriendlyByteBuf buffer) {
        return new PacketSidedWrapper(buffer.m_130135_(), buffer.m_130052_());
    }

    @Override
    public void handleClientSide(Player player) {
    }

    @Override
    public void handleServerSide(Player player) {
        BlockEntity tileEntity = player.m_9236_().m_7702_(this.posTile);
        if (tileEntity instanceof ISidedWrapper) {
            ISidedWrapper.SidedWrapper sidedWrapper = ((ISidedWrapper)tileEntity).getSidedWrapper();
            for (Direction facing : Direction.values()) {
                sidedWrapper.setFaceIndex(facing, this.indexes[facing.m_122411_()]);
            }
            tileEntity.invalidateCaps();
            Function.syncTile(tileEntity);
        }
    }
}

