/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.network;

import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraftforge.network.simple.SimpleChannel;
import shetiphian.core.common.network.PacketBase;
import shetiphian.core.common.network.PacketPipeline;
import shetiphian.core.common.network.PacketPlayerConfig;
import shetiphian.core.internal.network.PacketNameSync;
import shetiphian.core.internal.network.PacketParticle;
import shetiphian.core.internal.network.PacketSidedWrapper;
import shetiphian.core.internal.network.PacketTeamIdSync;
import shetiphian.core.internal.network.PacketTool;
import shetiphian.core.internal.teams.PacketTeamSync;

public class NetworkHandler
extends PacketPipeline {
    private static NetworkHandler INSTANCE;

    public static boolean isLoaded() {
        return INSTANCE != null;
    }

    public static void initialise(String modId) {
        INSTANCE = new NetworkHandler(modId, "1.0.0");
    }

    private NetworkHandler(String modId, String version) {
        super(modId, version);
    }

    @Override
    public void registerPackets(SimpleChannel wrapper) {
        int index = 0;
        wrapper.registerMessage(index++, PacketParticle.class, PacketParticle::writeData, PacketParticle::readData, PacketPipeline::onMessage);
        wrapper.registerMessage(index++, PacketSidedWrapper.class, PacketSidedWrapper::writeData, PacketSidedWrapper::readData, PacketPipeline::onMessage);
        wrapper.registerMessage(index++, PacketNameSync.class, PacketNameSync::writeData, PacketNameSync::readData, PacketPipeline::onMessage);
        wrapper.registerMessage(index++, PacketPlayerConfig.class, PacketPlayerConfig::writeData, PacketPlayerConfig::readData, PacketPipeline::onMessage);
        wrapper.registerMessage(index++, PacketTool.class, PacketTool::writeData, PacketTool::readData, PacketPipeline::onMessage);
        wrapper.registerMessage(index++, PacketTeamIdSync.class, PacketTeamIdSync::writeData, PacketTeamIdSync::readData, PacketPipeline::onMessage);
        wrapper.registerMessage(index++, PacketTeamSync.class, PacketTeamSync::writeData, PacketTeamSync::readData, PacketPipeline::onMessage);
    }

    public static void sendToServer(PacketBase packet) {
        INSTANCE.sendPacketToServer(packet);
    }

    public static void sendToPlayer(PacketBase packet, ServerPlayer player) {
        INSTANCE.sendPacketToPlayer(packet, player);
    }

    public static void sendToList(PacketBase packet, List<UUID> players) {
        INSTANCE.sendPacketToIdList(packet, players);
    }

    public static void sendToPoint(PacketBase packet, DimensionType dimension, BlockPos pos, double range) {
        INSTANCE.sendPacketToAllAround(packet, dimension, pos, range);
    }

    public static void sendToAll(PacketBase packet) {
        INSTANCE.sendPacketToAll(packet);
    }
}

