/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.internal.modintegration.jade;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec2;
import shetiphian.core.common.rgb16.IRGB16_Tile;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.tileentity.TileEntityExtendedRedstone;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.Identifiers;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

@WailaPlugin
public class JadePlugin
implements IWailaPlugin {
    private static final ResourceLocation CONFIG_RGB16 = new ResourceLocation("shetiphiancore", "hud.rgb16");
    private static final ResourceLocation CONFIG_REDSTONE = new ResourceLocation("shetiphiancore", "hud.redstone");

    public void register(IWailaCommonRegistration registration) {
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.addConfig(CONFIG_RGB16, true);
        registration.addConfig(CONFIG_REDSTONE, true);
        registration.registerBlockComponent((IBlockComponentProvider)ComponentProvider.INSTANCE, Block.class);
    }

    public static class ComponentProvider
    implements IBlockComponentProvider {
        static final ComponentProvider INSTANCE = new ComponentProvider();
        private static final ResourceLocation INFO_PROVIDER_ID = new ResourceLocation("shetiphiancore", "hud");
        private static final ItemStack REDSTONE = new ItemStack((ItemLike)Items.f_42451_);

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            RGB16 rgb16;
            BlockEntity tile = accessor.getBlockEntity();
            if (config.get(CONFIG_RGB16) && tile instanceof IRGB16_Tile && (rgb16 = ((IRGB16_Tile)tile).getRGB16(null)) != null) {
                tooltip.add((Component)Component.m_237113_((String)String.format("\u00a77RGB16: %s \u00a7f[\u00a77%d\u00a7f]", rgb16.getTooltip(), rgb16.getIndex())));
            }
            if (config.get(Identifiers.MC_REDSTONE) && tile instanceof TileEntityExtendedRedstone) {
                IElementHelper elements = tooltip.getElementHelper();
                IElement icon = elements.item(REDSTONE, 0.5f).size(new Vec2(10.0f, 10.0f)).translate(new Vec2(0.0f, -1.0f)).message(null);
                tooltip.add(icon);
                tooltip.append((Component)Component.m_237110_((String)"tooltip.jade.power", (Object[])new Object[]{String.format("\u00a7f%d", ((TileEntityExtendedRedstone)tile).getRSPower())}));
                if (config.get(CONFIG_REDSTONE)) {
                    tooltip.add(icon);
                    tooltip.append((Component)Component.m_237115_((String)"hud.shetiphiancore.extended_power").m_7220_((Component)Component.m_237113_((String)String.format(" \u00a7f%d", ((TileEntityExtendedRedstone)tile).getExPower()))));
                }
            }
        }

        public ResourceLocation getUid() {
            return INFO_PROVIDER_ID;
        }
    }
}

