/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.rgb16;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import shetiphian.core.common.rgb16.IRGB16_Item;
import shetiphian.core.common.rgb16.RGB16;
import shetiphian.core.common.rgb16.RGB16Helper;

public class RGB16StackHelper {
    public static ItemStack setRGB16(ItemStack stack, String colorName) {
        return RGB16StackHelper.setRGB16(stack, RGB16Helper.getIndexFor(colorName));
    }

    public static ItemStack setRGB16(ItemStack stack, RGB16 rgb16) {
        return RGB16StackHelper.setRGB16(stack, rgb16.getIndex());
    }

    public static ItemStack setRGB16(ItemStack stack, short rgbIndex) {
        if (stack.m_41720_() instanceof IRGB16_Item) {
            ((IRGB16_Item)stack.m_41720_()).setRGB16(stack, rgbIndex);
        }
        return stack;
    }

    public static short getRGB16Index(ItemStack stack) {
        if (stack.m_41720_() instanceof IRGB16_Item) {
            return ((IRGB16_Item)stack.m_41720_()).getRGB16(stack);
        }
        return -1;
    }

    public static RGB16 getRGB16(ItemStack stack) {
        short index = RGB16StackHelper.getRGB16Index(stack);
        return index >= 0 ? new RGB16(index) : null;
    }

    public static short readColorTag(ItemStack stack) {
        return RGB16StackHelper.readColorTag(stack, (short)4095);
    }

    public static short readColorTag(ItemStack stack, short defaultIndex) {
        CompoundTag nbt = RGB16StackHelper.getNBTTag(stack);
        if (!nbt.m_128441_("rgb16")) {
            RGB16StackHelper.writeColorTags(stack, defaultIndex);
        }
        return nbt.m_128448_("rgb16");
    }

    public static byte readSimpleColorTag(ItemStack stack) {
        return RGB16StackHelper.readSimpleColorTag(stack, (short)4095);
    }

    public static byte readSimpleColorTag(ItemStack stack, short defaultIndex) {
        CompoundTag nbt = RGB16StackHelper.getNBTTag(stack);
        if (!nbt.m_128441_("rgbsimple")) {
            RGB16StackHelper.writeColorTags(stack, defaultIndex);
        }
        return nbt.m_128445_("rgbsimple");
    }

    public static boolean writeColorTags(ItemStack stack, short rgbIndex) {
        rgbIndex = (short)Mth.m_14045_((int)rgbIndex, (int)0, (int)4096);
        CompoundTag nbt = RGB16StackHelper.getNBTTag(stack);
        if (!nbt.m_128441_("rgb16") || rgbIndex != RGB16StackHelper.readColorTag(stack)) {
            nbt.m_128376_("rgb16", rgbIndex);
            nbt.m_128344_("rgbsimple", RGB16Helper.getSimpleColor(rgbIndex));
            stack.m_41751_(nbt);
            return true;
        }
        return false;
    }

    private static CompoundTag getNBTTag(ItemStack stack) {
        return stack.m_41782_() ? stack.m_41783_() : new CompoundTag();
    }
}

