/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;
import shetiphian.core.common.item.ITooltipProvider;

public class BlockItemWithTooltip
extends BlockItem {
    private ITooltipProvider tooltipProvider;

    public BlockItemWithTooltip(Block block, Item.Properties builder, String tooltipKey) {
        this(block, builder, BlockItemWithTooltip.generate(tooltipKey));
    }

    private static Supplier<ITooltipProvider> generate(String tooltipKey) {
        MutableComponent text = Component.m_237115_((String)tooltipKey);
        return () -> BlockItemWithTooltip.lambda$generate$1((Component)text);
    }

    public BlockItemWithTooltip(Block block, Item.Properties builder, Supplier<ITooltipProvider> tooltipProvider) {
        super(block, builder);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.lambda$new$2((Supplier)tooltipProvider));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flag) {
        if (this.tooltipProvider != null) {
            this.tooltipProvider.build(stack, world, tooltip, flag.m_7050_());
        }
    }

    private /* synthetic */ void lambda$new$2(Supplier tooltipProvider) {
        this.tooltipProvider = (ITooltipProvider)tooltipProvider.get();
    }

    private static /* synthetic */ ITooltipProvider lambda$generate$1(Component text) {
        return (stack, world, tooltip, advanced) -> tooltip.add(text);
    }
}

