/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.DistExecutor;

public class ParticleHelper {
    public static boolean addLandingEffects(ServerLevel world, Entity entity, int numberOfParticles, BlockState particles) {
        world.m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, particles), entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), numberOfParticles, 0.0, 0.0, 0.0, (double)0.15f);
        return true;
    }

    public static boolean addRunningEffects(Level world, BlockPos pos, Entity entity, BlockState particles) {
        Vec3 vec3d = entity.m_20184_();
        EntityDimensions size = entity.m_6972_(entity.m_20089_());
        world.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, particles).setPos(pos), entity.m_20185_() + ((double)world.f_46441_.m_188501_() - 0.5) * (double)size.f_20377_, entity.m_20186_() + 0.1, entity.m_20189_() + ((double)world.f_46441_.m_188501_() - 0.5) * (double)size.f_20377_, vec3d.f_82479_ * -4.0, 1.5, vec3d.f_82481_ * -4.0);
        return true;
    }

    public static boolean addHitEffects(BlockState state, Level world, BlockPos pos, Direction side, ParticleEngine manager, BlockState particles) {
        AtomicBoolean result = new AtomicBoolean(false);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> result.set(Client.addHitEffects(state, world, pos, side, manager, particles)));
        return result.get();
    }

    public static boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager, BlockState particles) {
        AtomicBoolean result = new AtomicBoolean(false);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> result.set(Client.addDestroyEffects(state, world, pos, manager, particles)));
        return result.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class Client {
        private Client() {
        }

        public static boolean addHitEffects(BlockState state, Level world, BlockPos pos, Direction side, ParticleEngine manager, BlockState particles) {
            if (world instanceof ClientLevel && state.m_60799_() != RenderShape.INVISIBLE) {
                VoxelShape shape = state.m_60808_((BlockGetter)world, pos);
                if (shape.m_83281_()) {
                    return false;
                }
                int i = pos.m_123341_();
                int j = pos.m_123342_();
                int k = pos.m_123343_();
                AABB axisalignedbb = shape.m_83215_();
                double d0 = (double)i + world.f_46441_.m_188500_() * (axisalignedbb.f_82291_ - axisalignedbb.f_82288_ - (double)0.2f) + (double)0.1f + axisalignedbb.f_82288_;
                double d1 = (double)j + world.f_46441_.m_188500_() * (axisalignedbb.f_82292_ - axisalignedbb.f_82289_ - (double)0.2f) + (double)0.1f + axisalignedbb.f_82289_;
                double d2 = (double)k + world.f_46441_.m_188500_() * (axisalignedbb.f_82293_ - axisalignedbb.f_82290_ - (double)0.2f) + (double)0.1f + axisalignedbb.f_82290_;
                if (side == Direction.DOWN) {
                    d1 = (double)j + axisalignedbb.f_82289_ - (double)0.1f;
                }
                if (side == Direction.UP) {
                    d1 = (double)j + axisalignedbb.f_82292_ + (double)0.1f;
                }
                if (side == Direction.NORTH) {
                    d2 = (double)k + axisalignedbb.f_82290_ - (double)0.1f;
                }
                if (side == Direction.SOUTH) {
                    d2 = (double)k + axisalignedbb.f_82293_ + (double)0.1f;
                }
                if (side == Direction.WEST) {
                    d0 = (double)i + axisalignedbb.f_82288_ - (double)0.1f;
                }
                if (side == Direction.EAST) {
                    d0 = (double)i + axisalignedbb.f_82291_ + (double)0.1f;
                }
                manager.m_107344_(new TerrainParticle((ClientLevel)world, d0, d1, d2, 0.0, 0.0, 0.0, particles, pos).m_107268_(0.2f).m_6569_(0.6f));
                return true;
            }
            return false;
        }

        public static boolean addDestroyEffects(BlockState state, Level world, BlockPos pos, ParticleEngine manager, BlockState particles) {
            if (world instanceof ClientLevel && !state.m_60795_()) {
                VoxelShape voxelshape = state.m_60808_((BlockGetter)world, pos);
                voxelshape.m_83286_((minX, minY, minZ, maxX, maxY, maxZ) -> {
                    double d1 = Math.min(1.0, maxX - minX);
                    double d2 = Math.min(1.0, maxY - minY);
                    double d3 = Math.min(1.0, maxZ - minZ);
                    int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
                    int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
                    int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
                    for (int l = 0; l < i; ++l) {
                        for (int i1 = 0; i1 < j; ++i1) {
                            for (int j1 = 0; j1 < k; ++j1) {
                                double d4 = ((double)l + 0.5) / (double)i;
                                double d5 = ((double)i1 + 0.5) / (double)j;
                                double d6 = ((double)j1 + 0.5) / (double)k;
                                double d7 = d4 * d1 + minX;
                                double d8 = d5 * d2 + minY;
                                double d9 = d6 * d3 + minZ;
                                manager.m_107344_((Particle)new TerrainParticle((ClientLevel)world, (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, particles, pos));
                            }
                        }
                    }
                });
                return true;
            }
            return false;
        }
    }
}

