/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import commoble.morered.wire_post.AbstractPoweredWirePostBlock;
import commoble.morered.wire_post.SlackInterpolator;
import commoble.morered.wire_post.WirePostBlockEntity;
import commoble.morered.wire_post.WireSpoolItem;
import java.util.Set;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class WirePostRenderer
implements BlockEntityRenderer<WirePostBlockEntity> {
    public WirePostRenderer(BlockEntityRendererProvider.Context context) {
    }

    public static int getRed(Level world, BlockPos pos, BlockState state, float partialTicks) {
        int light = world.m_46803_(pos);
        float celestialAngle = world.m_46490_(partialTicks);
        if (light > 0) {
            float offset = celestialAngle < (float)Math.PI ? 0.0f : (float)Math.PI * 2;
            celestialAngle += (offset - celestialAngle) * 0.2f;
            light = Math.round((float)light * Mth.m_14089_((float)celestialAngle));
        }
        light = Math.max(light, world.m_45517_(LightLayer.BLOCK, pos));
        light = Mth.m_14045_((int)light, (int)0, (int)15);
        int power = state.m_61138_((Property)AbstractPoweredWirePostBlock.POWER) ? (Integer)state.m_61143_((Property)AbstractPoweredWirePostBlock.POWER) : 0;
        double lerpFactor = (double)power / 15.0;
        return (int)Mth.m_14139_((double)lerpFactor, (double)86.0, (double)255.0) * light / 15;
    }

    public void render(WirePostBlockEntity post, float partialTicks, PoseStack matrices, MultiBufferSource buffer, int combinedLightIn, int combinedOverlayIn) {
        BlockPos postPos = post.m_58899_();
        Vec3 postVector = WirePostBlockEntity.getConnectionVector(postPos);
        Set<BlockPos> connections = post.getRemoteConnections();
        Level world = post.m_58904_();
        BlockState postState = world.m_8055_(postPos);
        VertexConsumer vertexBuilder = buffer.m_6299_(RenderType.m_110504_());
        int postRed = WirePostRenderer.getRed(world, postPos, postState, partialTicks);
        for (BlockPos connectionPos : connections) {
            BlockState otherState = world.m_8055_(connectionPos);
            int red = Math.min(postRed, WirePostRenderer.getRed(world, connectionPos, otherState, partialTicks));
            this.renderConnection(post, world, partialTicks, matrices, vertexBuilder, postVector, WirePostBlockEntity.getConnectionVector(connectionPos), 0.0f, red);
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        for (InteractionHand hand : InteractionHand.values()) {
            float eyeHeight;
            double handZ;
            double handY;
            double handX;
            CompoundTag nbt;
            ItemStack stack = player.m_21120_(hand);
            if (!(stack.m_41720_() instanceof WireSpoolItem) || (nbt = stack.m_41737_("last_post_pos")) == null) continue;
            EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
            BlockPos positionOfCurrentPostOfPlayer = NbtUtils.m_129239_((CompoundTag)nbt);
            if (!positionOfCurrentPostOfPlayer.equals((Object)postPos)) continue;
            Vec3 vectorOfCurrentPostOfPlayer = Vec3.m_82512_((Vec3i)positionOfCurrentPostOfPlayer);
            int handSideID = -(hand == InteractionHand.MAIN_HAND ? -1 : 1) * (player.m_5737_() == HumanoidArm.RIGHT ? 1 : -1);
            float swingProgress = player.m_21324_(partialTicks);
            float swingZ = Mth.m_14031_((float)(Mth.m_14116_((float)swingProgress) * (float)Math.PI));
            float playerAngle = Mth.m_14179_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_) * ((float)Math.PI / 180);
            double playerAngleX = Mth.m_14031_((float)playerAngle);
            double playerAngleZ = Mth.m_14089_((float)playerAngle);
            double handOffset = (double)handSideID * 0.35;
            if (renderManager.f_114360_ == null || renderManager.f_114360_.m_92176_() == CameraType.FIRST_PERSON) {
                double fov = ((Integer)renderManager.f_114360_.m_231837_().m_231551_()).intValue();
                Vec3 handVector = new Vec3(-0.14 + (double)handSideID * -0.36 * (fov /= 100.0), -0.12 + -0.045 * fov, 0.4);
                handVector = handVector.m_82496_(-Mth.m_14179_((float)partialTicks, (float)player.f_19860_, (float)player.m_146909_()) * ((float)Math.PI / 180));
                handVector = handVector.m_82524_(-Mth.m_14179_((float)partialTicks, (float)player.f_19859_, (float)player.m_146908_()) * ((float)Math.PI / 180));
                handVector = handVector.m_82524_(swingZ * 0.5f);
                handVector = handVector.m_82496_(-swingZ * 0.7f);
                handX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) + handVector.f_82479_;
                handY = Mth.m_14139_((double)partialTicks, (double)player.f_19855_, (double)player.m_20186_()) + handVector.f_82480_;
                handZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) + handVector.f_82481_;
                eyeHeight = player.m_20192_();
            } else {
                handX = Mth.m_14139_((double)partialTicks, (double)player.f_19854_, (double)player.m_20185_()) - playerAngleZ * handOffset - playerAngleX * 0.8;
                handY = -0.2 + player.f_19855_ + (double)player.m_20192_() + (player.m_20186_() - player.f_19855_) * (double)partialTicks - 0.45;
                handZ = Mth.m_14139_((double)partialTicks, (double)player.f_19856_, (double)player.m_20189_()) - playerAngleX * handOffset + playerAngleZ * 0.8;
                eyeHeight = player.m_6047_() ? -0.1875f : 0.0f;
            }
            Vec3 renderPlayerVec = new Vec3(handX, handY + (double)eyeHeight, handZ);
            this.renderConnection(post, world, partialTicks, matrices, vertexBuilder, vectorOfCurrentPostOfPlayer, renderPlayerVec, eyeHeight, postRed);
        }
    }

    private void renderConnection(WirePostBlockEntity post, Level world, float partialTicks, PoseStack poseStack, VertexConsumer vertexBuilder, Vec3 startPos, Vec3 endPos, float eyeHeight, int red) {
        poseStack.m_85836_();
        boolean translateSwap = false;
        if (startPos.m_7098_() > endPos.m_7098_()) {
            Vec3 swap = startPos;
            startPos = endPos;
            endPos = swap;
            translateSwap = true;
        }
        poseStack.m_85837_(0.5, 0.5, 0.5);
        double startX = startPos.m_7096_();
        double startY = startPos.m_7098_();
        double startZ = startPos.m_7094_();
        double endX = endPos.m_7096_();
        double endY = endPos.m_7098_();
        double endZ = endPos.m_7094_();
        float dx = (float)(endX - startX);
        float dy = (float)(endY - startY);
        float dz = (float)(endZ - startZ);
        if (translateSwap) {
            poseStack.m_252880_(-dx, -dy, -dz);
        }
        Matrix4f fourMatrix = poseStack.m_85850_().m_252922_();
        if (startY <= endY) {
            Vec3[] pointList = SlackInterpolator.getInterpolatedDifferences(endPos.m_82546_(startPos));
            int points = pointList.length;
            int lines = points - 1;
            poseStack.m_85836_();
            for (int line = 0; line < lines; ++line) {
                Vec3 firstPoint = pointList[line];
                Vec3 secondPoint = pointList[line + 1];
                vertexBuilder.m_252986_(fourMatrix, (float)firstPoint.m_7096_(), (float)firstPoint.m_7098_(), (float)firstPoint.m_7094_()).m_6122_(red, 0, 0, 255).m_252939_(poseStack.m_85850_().m_252943_(), (float)firstPoint.m_7096_(), (float)firstPoint.m_7098_(), (float)firstPoint.m_7094_()).m_5752_();
                vertexBuilder.m_252986_(fourMatrix, (float)secondPoint.m_7096_(), (float)secondPoint.m_7098_(), (float)secondPoint.m_7094_()).m_6122_(red, 0, 0, 255).m_252939_(poseStack.m_85850_().m_252943_(), (float)secondPoint.m_7096_(), (float)secondPoint.m_7098_(), (float)secondPoint.m_7094_()).m_5752_();
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    public boolean shouldRenderOffScreen(WirePostBlockEntity te) {
        return true;
    }
}

