/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import commoble.morered.client.EdgeRotation;
import commoble.morered.mixin.ClientElementsModelAccess;
import commoble.morered.wires.Edge;
import java.util.function.Function;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.ElementsModel;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.SimpleUnbakedGeometry;
import org.joml.Matrix4f;

public class TintRotatingModelLoader
implements IGeometryLoader<TintRotatingModelGeometry> {
    public static final TintRotatingModelLoader INSTANCE = new TintRotatingModelLoader();

    public TintRotatingModelGeometry read(JsonObject modelContents, JsonDeserializationContext context) {
        ElementsModel proxy = ElementsModel.Loader.INSTANCE.read(modelContents, context);
        return new TintRotatingModelGeometry(proxy);
    }

    public static class TintRotatingModelGeometry
    extends SimpleUnbakedGeometry<TintRotatingModelGeometry> {
        private final ElementsModel elementsModel;

        public TintRotatingModelGeometry(ElementsModel proxy) {
            this.elementsModel = proxy;
        }

        public void addQuads(IGeometryBakingContext context, IModelBuilder<?> modelBuilder, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
            TintRotatingModelBuilder builderWrapper = new TintRotatingModelBuilder(modelBuilder, modelTransform);
            ((ClientElementsModelAccess)this.elementsModel).callAddQuads(context, builderWrapper, bakery, spriteGetter, modelTransform, modelLocation);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext owner) {
            this.elementsModel.resolveParents(modelGetter, owner);
        }
    }

    public static class TintRotatingModelBuilder
    implements IModelBuilder<TintRotatingModelBuilder> {
        private final IModelBuilder<?> delegate;
        private final Matrix4f rotation;

        public TintRotatingModelBuilder(IModelBuilder<?> delegate, ModelState modelTransform) {
            this.delegate = delegate;
            this.rotation = modelTransform.m_6189_().m_252783_();
        }

        public TintRotatingModelBuilder addCulledFace(Direction facing, BakedQuad quad) {
            BakedQuad tintRotatedQuad = this.getTintRotatedQuad(quad);
            this.delegate.addCulledFace(facing, tintRotatedQuad);
            return this;
        }

        public TintRotatingModelBuilder addUnculledFace(BakedQuad quad) {
            BakedQuad tintRotatedQuad = this.getTintRotatedQuad(quad);
            this.delegate.addUnculledFace(tintRotatedQuad);
            return this;
        }

        public BakedModel build() {
            return this.delegate.build();
        }

        protected BakedQuad getTintRotatedQuad(BakedQuad baseQuad) {
            int newTint = this.rotateTint(baseQuad.m_111305_());
            return new BakedQuad(baseQuad.m_111303_(), newTint, baseQuad.m_111306_(), baseQuad.m_173410_(), baseQuad.m_111307_());
        }

        protected int rotateTint(int baseTint) {
            return baseTint < 1 ? baseTint : (baseTint < 7 ? this.rotateSide(baseTint) : (baseTint < 19 ? this.rotateEdge(baseTint) : baseTint));
        }

        protected int rotateSide(int baseTint) {
            int ordinal = baseTint - 1;
            Direction baseDir = Direction.m_122376_((int)ordinal);
            Direction newDir = Direction.m_252919_((Matrix4f)this.rotation, (Direction)baseDir);
            return newDir.ordinal() + 1;
        }

        protected int rotateEdge(int baseTint) {
            int ordinal = baseTint - 7;
            return EdgeRotation.getRotatedEdge(Edge.values()[ordinal], this.rotation).ordinal() + 7;
        }
    }
}

