/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import commoble.morered.util.ConfigHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public record ClientConfig(ForgeConfigSpec.ConfigValue<Boolean> showPlacementPreview, ForgeConfigSpec.ConfigValue<Double> previewPlacementOpacity) {
    public static ClientConfig INSTANCE;

    public static void initClientConfig() {
        INSTANCE = ConfigHelper.register(ModConfig.Type.CLIENT, ClientConfig::create);
    }

    public static ClientConfig create(ForgeConfigSpec.Builder builder) {
        builder.push("Rendering");
        ForgeConfigSpec.BooleanValue showPlacementPreview = builder.comment("Render preview of plate blocks before placing them").translation("morered.showPlacementPreview").define("showPlacementPreview", true);
        ForgeConfigSpec.DoubleValue previewPlacementOpacity = builder.comment("Opacity of the render preview. Higher value = less transparent, lower = more transparent").translation("morered.showPlacementPreview").defineInRange("previewPlacementOpacity", 0.4, 0.0, 1.0);
        builder.pop();
        return new ClientConfig((ForgeConfigSpec.ConfigValue<Boolean>)showPlacementPreview, (ForgeConfigSpec.ConfigValue<Double>)previewPlacementOpacity);
    }
}

