/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public abstract class SimpleJsonResourceReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger f_10762_ = LogUtils.getLogger();
    private final Gson f_10764_;
    private final String f_10765_;

    public SimpleJsonResourceReloadListener(Gson p_10768_, String p_10769_) {
        this.f_10764_ = p_10768_;
        this.f_10765_ = p_10769_;
    }

    protected Map<ResourceLocation, JsonElement> m_5944_(ResourceManager p_10771_, ProfilerFiller p_10772_) {
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        SimpleJsonResourceReloadListener.m_278771_(p_10771_, this.f_10765_, this.f_10764_, map);
        return map;
    }

    public static void m_278771_(ResourceManager p_279308_, String p_279131_, Gson p_279261_, Map<ResourceLocation, JsonElement> p_279404_) {
        FileToIdConverter filetoidconverter = FileToIdConverter.m_246568_((String)p_279131_);
        for (Map.Entry entry : filetoidconverter.m_247457_(p_279308_).entrySet()) {
            ResourceLocation resourcelocation = (ResourceLocation)entry.getKey();
            ResourceLocation resourcelocation1 = filetoidconverter.m_245273_(resourcelocation);
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonElement jsonelement = (JsonElement)GsonHelper.m_13776_((Gson)p_279261_, (Reader)reader, JsonElement.class);
                    JsonElement jsonelement1 = p_279404_.put(resourcelocation1, jsonelement);
                    if (jsonelement1 == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + String.valueOf(resourcelocation1));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                f_10762_.error("Couldn't parse data file {} from {}", new Object[]{resourcelocation1, resourcelocation, jsonparseexception});
            }
        }
    }

    protected ResourceLocation getPreparedPath(ResourceLocation rl) {
        return rl.m_247449_(this.f_10765_ + "/" + rl.m_135815_() + ".json");
    }
}

