/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content.brewery;

import com.mojang.blaze3d.systems.RenderSystem;
import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.content.brewery.ContainerMenuAdvancedBrewery;
import de.melanx.utilitix.content.brewery.TileAdvancedBrewery;
import java.awt.Color;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.common.MinecraftForge;

public class ScreenAdvancedBrewery
extends AbstractContainerScreen<ContainerMenuAdvancedBrewery> {
    public static final ResourceLocation TEXTURE = new ResourceLocation(UtilitiX.getInstance().modid, "textures/container/advanced_brewery.png");
    private static final int[] BUBBLE_SIZES = new int[]{29, 24, 20, 16, 11, 6, 0};
    private int relX;
    private int relY;

    public ScreenAdvancedBrewery(ContainerMenuAdvancedBrewery menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        MinecraftForge.EVENT_BUS.addListener(this::onGuiInit);
    }

    private void onGuiInit(ScreenEvent.Init event) {
        this.relX = (event.getScreen().f_96543_ - this.f_97726_) / 2;
        this.relY = (event.getScreen().f_96544_ - this.f_97727_) / 2;
    }

    public void m_88315_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(guiGraphics);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_7286_(@Nonnull GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.m_280218_(TEXTURE, this.relX, this.relY, 0, 0, this.f_97726_, this.f_97727_);
        TileAdvancedBrewery tile = (TileAdvancedBrewery)((ContainerMenuAdvancedBrewery)this.f_97732_).getBlockEntity();
        int fuelWidth = Mth.m_14045_((int)Math.round((float)(18 * tile.getFuel() + 19) / 20.0f), (int)0, (int)18);
        if (tile.getFuel() > 0 && fuelWidth > 0) {
            guiGraphics.m_280218_(TEXTURE, this.relX + 60, this.relY + 44, 176, 29, fuelWidth, 4);
        }
        int brewTime = Mth.m_14045_((int)tile.getBrewTime(), (int)0, (int)400);
        if (tile.getFuel() > 0 && brewTime > 0) {
            int textureHeight = Mth.m_14045_((int)Math.round(28.0f * ((float)brewTime / 400.0f)), (int)0, (int)28);
            if (textureHeight > 0) {
                guiGraphics.m_280218_(TEXTURE, this.relX + 97, this.relY + 16, 176, 0, 9, textureHeight);
            }
            if ((textureHeight = BUBBLE_SIZES[(400 - brewTime) / 2 % BUBBLE_SIZES.length]) > 0) {
                guiGraphics.m_280218_(TEXTURE, this.relX + 63, this.relY + 14 + 29 - textureHeight, 185, 29 - textureHeight, 12, textureHeight);
            }
        }
    }

    protected void m_280003_(@Nonnull GuiGraphics guiGraphics, int mouseX, int mouseY) {
        String s = this.f_96539_.getString();
        guiGraphics.m_280056_(this.f_96547_, s, this.f_97726_ / 2 - this.f_96547_.m_92895_(s) / 2, 5, Color.DARK_GRAY.getRGB(), false);
        guiGraphics.m_280614_(this.f_96547_, this.f_169604_, 8, this.f_97727_ - 94, Color.DARK_GRAY.getRGB(), false);
    }
}

