/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.content;

import de.melanx.utilitix.UtilitiX;
import de.melanx.utilitix.UtilitiXConfig;
import de.melanx.utilitix.network.ItemEntityRepaired;
import de.melanx.utilitix.util.BoundingBoxUtils;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class BetterMending {
    @SubscribeEvent
    public void pullXP(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.level instanceof ServerLevel) {
            this.moveExps(event.level, ((ServerLevel)event.level).m_142646_().m_142273_());
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void pullXPClient(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && Minecraft.m_91087_().f_91073_ != null) {
            this.moveExps((Level)Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91073_.m_104735_());
        }
    }

    private void moveExps(Level level, Iterable<Entity> entities) {
        if (!UtilitiXConfig.betterMending) {
            return;
        }
        block0: for (Entity entity : entities) {
            ItemEntity item;
            ItemStack stack;
            if (!(entity instanceof ItemEntity) || (stack = (item = (ItemEntity)entity).m_32055_()).m_41773_() <= 0 || stack.getEnchantmentLevel(Enchantments.f_44962_) <= 0) continue;
            List xps = level.m_45976_(ExperienceOrb.class, BoundingBoxUtils.expand((Entity)item, 7.0));
            for (ExperienceOrb orb : xps) {
                Vec3 vector = new Vec3(item.m_20185_() - orb.m_20185_(), item.m_20186_() + (double)(orb.m_20192_() / 2.0f) - orb.m_20186_(), item.m_20189_() - orb.m_20189_());
                if (vector.m_82556_() < 0.2 && !level.f_46443_) {
                    int i = Math.min((int)((float)orb.m_20801_() * stack.getXpRepairRatio()), stack.m_41773_());
                    stack.m_41721_(stack.m_41773_() - i);
                    orb.m_142687_(Entity.RemovalReason.KILLED);
                    if (stack.m_41768_()) continue;
                    UtilitiX.getNetwork().channel.send(PacketDistributor.TRACKING_ENTITY.with(() -> item), (Object)new ItemEntityRepaired(item.m_19879_()));
                    continue block0;
                }
                double scale = 1.0 - vector.m_82553_() / 8.0;
                orb.m_20256_(orb.m_20184_().m_82549_(vector.m_82541_().m_82490_(scale * scale * 0.1)));
            }
        }
    }
}

