/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.cookingforblockheads.client;

import java.util.HashSet;
import java.util.Set;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.balm.api.event.client.ItemTooltipEvent;
import net.blay09.mods.balm.api.event.client.RecipesUpdatedEvent;
import net.blay09.mods.balm.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.cookingforblockheads.api.RecipeStatus;
import net.blay09.mods.cookingforblockheads.client.ModModels;
import net.blay09.mods.cookingforblockheads.client.ModRenderers;
import net.blay09.mods.cookingforblockheads.client.ModScreens;
import net.blay09.mods.cookingforblockheads.client.ModTextures;
import net.blay09.mods.cookingforblockheads.client.gui.screen.RecipeBookScreen;
import net.blay09.mods.cookingforblockheads.menu.RecipeBookMenu;
import net.blay09.mods.cookingforblockheads.menu.slot.CraftMatrixFakeSlot;
import net.blay09.mods.cookingforblockheads.menu.slot.RecipeFakeSlot;
import net.blay09.mods.cookingforblockheads.registry.CookingRegistry;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeType;
import net.blay09.mods.cookingforblockheads.registry.FoodRecipeWithIngredients;
import net.blay09.mods.cookingforblockheads.util.TextUtils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CookingForBlockheadsClient {
    private static final Set<ResourceLocation> favoriteItemIds = new HashSet<ResourceLocation>();

    public static void initialize() {
        ModRenderers.initialize(BalmClient.getRenderers());
        ModScreens.initialize(BalmClient.getScreens());
        ModTextures.initialize(BalmClient.getTextures());
        ModModels.initialize(BalmClient.getModels());
        Balm.getEvents().onEvent(RecipesUpdatedEvent.class, event -> CookingRegistry.initFoodRegistry(event.getRecipeManager(), event.getRegistryAccess()));
        Balm.getEvents().onEvent(ItemTooltipEvent.class, event -> {
            Screen patt2028$temp = Minecraft.m_91087_().f_91080_;
            if (!(patt2028$temp instanceof RecipeBookScreen)) return;
            RecipeBookScreen screen = (RecipeBookScreen)patt2028$temp;
            RecipeBookMenu menu = (RecipeBookMenu)screen.m_6262_();
            Slot hoverSlot = ((AbstractContainerScreenAccessor)screen).getHoveredSlot();
            if (hoverSlot instanceof RecipeFakeSlot) {
                RecipeFakeSlot recipeSlot = (RecipeFakeSlot)hoverSlot;
                if (event.getItemStack() == hoverSlot.m_7993_()) {
                    if (menu.isSelectedSlot(recipeSlot) && menu.isAllowCrafting()) {
                        FoodRecipeWithIngredients subRecipe = menu.getSelection();
                        if (subRecipe == null) {
                            return;
                        }
                        if (subRecipe.getRecipeType() == FoodRecipeType.SMELTING) {
                            if (!menu.hasOven()) {
                                event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:missing_oven", ChatFormatting.RED));
                                return;
                            }
                            if (Screen.m_96638_()) {
                                event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_smelt_stack", ChatFormatting.GREEN));
                                return;
                            }
                            event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_smelt_one", ChatFormatting.GREEN));
                            return;
                        }
                        if (subRecipe.getRecipeStatus() == RecipeStatus.MISSING_TOOLS) {
                            event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:missing_tools", ChatFormatting.RED));
                            return;
                        }
                        if (subRecipe.getRecipeStatus() == RecipeStatus.MISSING_INGREDIENTS) {
                            event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:missing_ingredients", ChatFormatting.RED));
                            return;
                        }
                        if (Screen.m_96638_()) {
                            event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_craft_stack", ChatFormatting.GREEN));
                            return;
                        }
                        event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_craft_one", ChatFormatting.GREEN));
                        return;
                    }
                    event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_see_recipe", ChatFormatting.YELLOW));
                    return;
                }
            }
            if (!(hoverSlot instanceof CraftMatrixFakeSlot)) return;
            if (event.getItemStack() != hoverSlot.m_7993_()) return;
            if (((CraftMatrixFakeSlot)hoverSlot).getVisibleStacks().size() <= 1) return;
            if (((CraftMatrixFakeSlot)hoverSlot).isLocked()) {
                event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_unlock", ChatFormatting.GREEN));
            } else {
                event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:click_to_lock", ChatFormatting.GREEN));
            }
            event.getToolTip().add(TextUtils.coloredTextComponent("tooltip.cookingforblockheads:scroll_to_switch", ChatFormatting.YELLOW));
        });
    }

    public static void setFavoriteItems(Set<ResourceLocation> favoriteItemIds) {
        CookingForBlockheadsClient.favoriteItemIds.clear();
        CookingForBlockheadsClient.favoriteItemIds.addAll(favoriteItemIds);
    }

    public static boolean isFavoriteItem(ItemStack itemStack) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)itemStack.m_41720_());
        return favoriteItemIds.contains(itemId);
    }
}

